/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.metadata.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.lang3.ArrayUtils;

import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.metadata.ModifiableCompositeMetadata;
import org.ametys.plugins.repository.metadata.ModifiableFolder;
import org.ametys.plugins.repository.metadata.ModifiableRichText;
import org.ametys.plugins.repository.metadata.RichText;
import org.ametys.plugins.repository.metadata.UnknownMetadataException;

/**
 * JCR implementation of a {@link RichText}, based on the ametys:richText nodetype.<br>
 * @deprecated Use org.ametys.cms.data.RichText instead
 */
@Deprecated
public class JCRRichText extends JCRResource implements ModifiableRichText
{
    
    /** The annotations node name. */
    private static final String _ANNOTATIONS_NODE_NAME = "annotations";
    
    private Node _rootDataNode;
    private AmetysObjectResolver _resolver;
    
    /**
     * Constructor
     * @param node the JCR Node backing this {@link JCRRichText}
     * @param resolver The resolver, used to resolve object collections.
     * @throws AmetysRepositoryException if an error occurs
     */
    public JCRRichText(Node node, AmetysObjectResolver resolver) throws AmetysRepositoryException
    {
        super(node);
        
        _resolver = resolver;
        
        try
        {
            _rootDataNode = node.getNode("data");
        }
        catch (RepositoryException e)
        {
            throw new AmetysRepositoryException(e);
        }
    }
    
    public ModifiableFolder getAdditionalDataFolder()
    {
        return new JCRFolder(_rootDataNode);
    }
    
    @Override
    public String[] getAnnotationNames() throws AmetysRepositoryException
    {
        try
        {
            ModifiableCompositeMetadata annotations = getAnnotationsNode(false);
            
            return annotations.getMetadataNames();
        }
        catch (UnknownMetadataException e)
        {
            // Ignore, just return an empty array.
        }
        
        return new String[0];
    }
    
    @Override
    public String[] getAnnotationValues(String name) throws AmetysRepositoryException
    {
        try
        {
            ModifiableCompositeMetadata annotations = getAnnotationsNode(false);
            if (annotations.hasMetadata(name))
            {
                return annotations.getStringArray(name);
            }
        }
        catch (UnknownMetadataException e)
        {
            // Ignore, just return an empty array.
        }
        
        return new String[0];
    }
    
    @Override
    public void addAnnotation(String name, String value) throws AmetysRepositoryException
    {
        String[] currentValues = getAnnotationValues(name);
        getAnnotationsNode(true).setMetadata(name, ArrayUtils.add(currentValues, value));
    }
    
    @Override
    public void addAnnotation(String name, String[] values) throws AmetysRepositoryException
    {
        String[] currentValues = getAnnotationValues(name);
        getAnnotationsNode(true).setMetadata(name, ArrayUtils.addAll(currentValues, values));
    }
    
    @Override
    public void removeAnnotations() throws AmetysRepositoryException
    {
        try
        {
            _checkLock();
            if (getNode().hasNode(_ANNOTATIONS_NODE_NAME))
            {
                getNode().getNode(_ANNOTATIONS_NODE_NAME).remove(); 
            }
        }
        catch (RepositoryException e)
        {
            throw new AmetysRepositoryException(e);
        }
    }
    
    @Override
    public void removeAnnotation(String name) throws AmetysRepositoryException
    {
        ModifiableCompositeMetadata annotations = getAnnotationsNode(true);
        if (annotations.hasMetadata(name))
        {
            annotations.removeMetadata(name);
        }
    }
    
    /**
     * Get the annotations container node.
     * @param createNew <code>true</code> to create the node if it doesn't exist, <code>false</code> otherwise.
     * @return The annotation container node.
     * @throws UnknownMetadataException If the node doesn't exist and createNew is false.
     * @throws AmetysRepositoryException If a repository error occurs.
     */
    protected ModifiableCompositeMetadata getAnnotationsNode(boolean createNew) throws UnknownMetadataException, AmetysRepositoryException
    {
        try
        {
            if (getNode().hasNode(_ANNOTATIONS_NODE_NAME))
            {
                Node node = getNode().getNode(_ANNOTATIONS_NODE_NAME);
                return new JCRCompositeMetadata(node, _resolver);
            }
            else if (createNew)
            {
                _checkLock();
                Node node = getNode().addNode(_ANNOTATIONS_NODE_NAME, "ametys:compositeMetadata");
                return new JCRCompositeMetadata(node, _resolver);
            }
            else
            {
                throw new UnknownMetadataException("No annotation found");
            }
        }
        catch (RepositoryException e)
        {
            throw new AmetysRepositoryException(e);
        }
    }
}
