/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.migration.jcr;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.ObservationConstants;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;

/**
 * {@link Observer} launched when the migration is finish.
 */
public class JcrDataMigrationEndedObserver implements Observer, Serviceable
{
    private VersionsRootHelper _versionsRootHelper;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _versionsRootHelper = (VersionsRootHelper) manager.lookup(VersionsRootHelper.ROLE);
    }
    
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(ObservationConstants.EVENT_MIGRATION_ENDED);
    }

    @Override
    public int getPriority()
    {
        return 0;
    }

    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        _versionsRootHelper.updateKnownPlugins();
    }
}
