/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.migration.jcr.repository;

import java.util.Calendar;

import javax.jcr.Node;

import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;

/**
 * Ametys object representing a version for migration.
 */
public class VersionAmetysObject extends SimpleAmetysObject<VersionFactory>
{
    /** The component ID attribute name */
    public static final String COMPONENT_ID = "componentId";
    
    /** The version number attribute name */
    public static final String VERSION_NUMBER = "versionNumber";

    /** The execution date attribute name */
    public static final String EXECUTION_DATE = "executionDate";

    /** The comment attribute name */
    public static final String COMMENT = "comment";
    
    /** The repository data */
    protected ModifiableRepositoryData _repositoryData;

    /**
     * Constructor.
     * @param node the JCR Node.
     * @param parentPath the parent path
     * @param factory the corresponding factory.
     */
    public VersionAmetysObject(Node node, String parentPath, VersionFactory factory)
    {
        super(node, parentPath, factory);
        _repositoryData = new JCRRepositoryData(getNode());
    }

    /**
     * Get the component id.
     * @return the component id
     */
    public String getComponentId()
    {
        return _repositoryData.getString(COMPONENT_ID);
    }
    
    /**
     * Set the component id.
     * @param componentId the component id
     */
    public void setComponentId(String componentId)
    {
        _repositoryData.setValue(COMPONENT_ID, componentId);
    }

    /**
     * Get the version number.
     * @return the version number
     */
    public String getVersionNumber()
    {
        return _repositoryData.getString(VERSION_NUMBER);
    }
    
    /**
     * Set the version number.
     * @param versionNumber the version number
     */
    public void setVersionNumber(String versionNumber)
    {
        _repositoryData.setValue(VERSION_NUMBER, versionNumber);
    }

    /**
     * Get the execution date.
     * @return the execution date
     */
    public Calendar getExecutionDate()
    {
        return _repositoryData.getDate(EXECUTION_DATE);
    }
    
    /**
     * Set the execution date.
     * @param executionDate the execution date
     */
    public void setExecutionDate(Calendar executionDate)
    {
        _repositoryData.setValue(EXECUTION_DATE, executionDate);
    }

    /**
     * Get the comment.
     * @return the comment
     */
    public String getComment()
    {
        if (_repositoryData.hasValue(COMMENT))
        {
            return _repositoryData.getString(COMMENT);
        }
        return null;
    }
    
    /**
     * Set the comment.
     * @param comment the comment
     */
    public void setComment(String comment)
    {
        _repositoryData.setValue(COMMENT, comment);
    }
}
