/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.migration.jcr.repository;

import javax.jcr.Node;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;

/**
 * Class representing a version component
 */
public class VersionComponentAmetysObject extends DefaultTraversableAmetysObject<VersionComponentFactory>
{
    /** Metadata name for storing a Node's lockToken */
    public static final String COMPONENT_ID = "componentId";

    /** The repository data */
    protected ModifiableRepositoryData _repositoryData;

    /**
     * Constructor.
     * @param node the JCR Node.
     * @param parentPath the parent path
     * @param factory the corresponding factory.
     */
    public VersionComponentAmetysObject(Node node, String parentPath, VersionComponentFactory factory)
    {
        super(node, parentPath, factory);
        _repositoryData = new JCRRepositoryData(getNode());
    }
    
    /**
     * Get the component identifier.
     * @return the component identifier
     */
    public String getComponentId()
    {
        return _repositoryData.getString(COMPONENT_ID);
    }
    
    /**
     * Set the component identifier.
     * @param componentId the component identifier
     * @throws AmetysRepositoryException if an error occurs
     */
    public void setComponentId(String componentId) throws AmetysRepositoryException
    {
        _repositoryData.setValue(COMPONENT_ID, componentId);
    }
}
