/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.migration.jcr.repository;

import java.util.Set;

import javax.jcr.Node;

import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;

/**
 * Object representing the versions root element.
 */
public class VersionsAmetysObject extends DefaultTraversableAmetysObject<VersionsFactory>
{
    /** Metadata name for storing a Node's lockToken */
    public static final String KNOWN_PLUGINS = "knownPlugins";
    
    /** The repository data */
    protected ModifiableRepositoryData _repositoryData;

    /**
     * Constructor.
     * @param node the JCR Node.
     * @param parentPath the parent path
     * @param factory the corresponding factory.
     */
    public VersionsAmetysObject(Node node, String parentPath, VersionsFactory factory)
    {
        super(node, parentPath, factory);
        _repositoryData = new JCRRepositoryData(getNode());
    }
    
    /**
     * Get all the known plugins.
     * @return the known plugins
     */
    public Set<String> getKnownPlugins()
    {
        if (_repositoryData.hasValue(KNOWN_PLUGINS))
        {
            return Set.of(_repositoryData.getStrings(KNOWN_PLUGINS));
        }
        
        return Set.of();
    }
    
    /**
     * Set the known plugins.
     * @param knownPlugins the known plugins
     * @throws AmetysRepositoryException if an error occurs
     */
    public void setKnownPlugins(Set<String> knownPlugins) throws AmetysRepositoryException
    {
        _repositoryData.setValues(KNOWN_PLUGINS, knownPlugins.toArray(String[]::new));
    }
}
