/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.model;

import org.ametys.runtime.model.DefinitionAndValue;
import org.ametys.runtime.model.ModelItem;

/**
 * Pair of a value and its definition for a repeater entry
 * @param <T> Type of the root object
 */
public class RepeaterEntryDefinitionAndValue<T> extends CompositeDefinitionAndValue<T>
{
    private RepeaterDefinition _repeaterDefinition;
    
    /**
     * Creates a repeater entry definition and value pair
     * @param root the root object of this definition and value pair
     * @param definition the definition
     * @param value the value
     * @param children the children of the definition and value pair
     */
    public RepeaterEntryDefinitionAndValue(T root, ModelItem definition, Object value, DefinitionAndValue... children)
    {
        this(root, definition, value, null, children);
    }
    
    /**
     * Creates a repeater entry definition and value pair
     * @param root the root object of this definition and value pair
     * @param definition the definition
     * @param value the value
     * @param parent the parent of the definition and value pair
     * @param children the children of the definition and value pair
     */
    public RepeaterEntryDefinitionAndValue(T root, ModelItem definition, Object value, DefinitionAndValue<T> parent, DefinitionAndValue... children)
    {
        super(root, definition, value, parent, children);
        
        if (definition instanceof RepeaterDefinition)
        {
            _repeaterDefinition = (RepeaterDefinition) definition;
        }
        else
        {
            throw new IllegalArgumentException("The definition of a repeater entry definition and value pair must be a " + RepeaterDefinition.class.getName() + ".");
        }
    }
    
    @Override
    public RepeaterDefinition getDefinition()
    {
        return _repeaterDefinition;
    }
}
