/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.model.parsing;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.runtime.model.AbstractModelItemParser;
import org.ametys.runtime.model.ItemParserHelper;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.type.ModelItemTypeExtensionPoint;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;

/**
 * This class parses the composite definition
 * @param <D> The type of disable conditions managed by the parsed composite
 */
public abstract class AbstractCompositeDefinitionParser<D extends DisableConditions> extends AbstractModelItemParser<D>
{
    /**
     * Creates a composite definition parser.
     * @param modelItemTypeExtensionPoint the extension point to use to get available model items types
     * @param disableConditionsManager the disable conditions component manager
     */
    public AbstractCompositeDefinitionParser(ModelItemTypeExtensionPoint modelItemTypeExtensionPoint, ThreadSafeComponentManager<DisableConditions> disableConditionsManager)
    {
        super(modelItemTypeExtensionPoint, disableConditionsManager);
    }
    
    @Override
    protected CompositeDefinition _createModelItem(Configuration itemConfig) throws ConfigurationException
    {
        return new CompositeDefinition();
    }
    
    @Override
    protected String _parseName(Configuration itemConfig) throws ConfigurationException
    {
        return ItemParserHelper.parseName(itemConfig, _getNameConfigurationAttribute(), false);
    }

}
