/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.model.parsing;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.plugins.repository.data.type.ModelItemTypeConstants;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.model.AbstractModelItemParser;
import org.ametys.runtime.model.ItemParserHelper;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.model.type.ModelItemTypeExtensionPoint;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;

/**
 * This class parses the repeater definition
 * @param <D> The type of disable conditions managed by the parsed repeater
 */
public abstract class AbstractRepeaterDefinitionParser<D extends DisableConditions> extends AbstractModelItemParser<D>
{
    /**
     * Creates a repeater definition parser.
     * @param modelItemTypeExtensionPoint the extension point to use to get available model items types
     * @param disableConditionsManager the disable conditions component manager
     */
    public AbstractRepeaterDefinitionParser(ModelItemTypeExtensionPoint modelItemTypeExtensionPoint, ThreadSafeComponentManager<DisableConditions> disableConditionsManager)
    {
        super(modelItemTypeExtensionPoint, disableConditionsManager);
    }
    
    @Override
    @SuppressWarnings("unchecked")
    public <T extends ModelItem> T parse(ServiceManager serviceManager, String pluginName, String catalog, Configuration definitionConfig, Model model, ModelItemGroup parent) throws ConfigurationException
    {
        RepeaterDefinition definition = (RepeaterDefinition) super.parse(serviceManager, pluginName, catalog, definitionConfig, model, parent);
        
        definition.setAddLabel(_parseI18nizableText(definitionConfig, catalog, "add-label", "plugin.repository", "PLUGINS_REPOSITORY_REPEATER_DEFAULT_ADD_LABEL"));
        definition.setDeleteLabel(_parseI18nizableText(definitionConfig, catalog, "del-label", "plugin.repository", "PLUGINS_REPOSITORY_REPEATER_DEFAULT_DELETE_LABEL"));
        definition.setHeaderLabel(definitionConfig.getChild("header-label").getValue(null));
        definition.setInitialSize(definitionConfig.getAttributeAsInteger("initial-size", 0));
        definition.setMinSize(definitionConfig.getAttributeAsInteger("min-size", 0));
        definition.setMaxSize(definitionConfig.getAttributeAsInteger("max-size", -1));
        
        return (T) definition;
    }

    @Override
    protected RepeaterDefinition _createModelItem(Configuration itemConfig) throws ConfigurationException
    {
        return new RepeaterDefinition();
    }
    
    @Override
    protected String _parseName(Configuration itemConfig) throws ConfigurationException
    {
        return ItemParserHelper.parseName(itemConfig, _getNameConfigurationAttribute(), false);
    }
    
    @Override
    protected ModelItemType _parseType(Configuration config) throws ConfigurationException
    {
        return _modelItemTypeExtensionPoint.getExtension(ModelItemTypeConstants.REPEATER_TYPE_ID);
    }
}
