/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.provider;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;

import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.security.authentication.AuthContext;

/**
 * Implementation of a JCR Session that is poolable.<br>
 * The logout method actually bring the Session back into the pool.
 */
public class AmetysSession extends XASessionImpl
{
    private AmetysRepository _repository;
    
    /**
     * Create a new Session.
     * @param repositoryCtx repository context
     * @param loginCtx login context containing authenticated subject
     * @param wspConfig workspace configuration
     * @throws AccessDeniedException if the given subject is not granted access
     *                               to the specified workspace
     * @throws RepositoryException   if another error occurs
     */
    protected AmetysSession(RepositoryContext repositoryCtx, AuthContext loginCtx, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException
    {
        super(repositoryCtx, loginCtx, wspConfig);
        _repository = (AmetysRepository) repositoryContext.getRepository();
    }
    
    /**
     * Create a new Session.
     * @param repositoryCtx repository context
     * @param sub authenticated subject
     * @param wspConfig workspace configuration
     * @throws AccessDeniedException if the given subject is not granted access
     *                               to the specified workspace
     * @throws RepositoryException   if another error occurs
     */
    public AmetysSession(RepositoryContext repositoryCtx, Subject sub, WorkspaceConfig wspConfig) throws AccessDeniedException, RepositoryException
    {
        super(repositoryCtx, sub, wspConfig);
        _repository = (AmetysRepository) repositoryContext.getRepository();
    }
    
    @Override
    public synchronized void logout()
    {
        LogoutManager logoutManager = _repository.getLogoutManager();
        
        if (logoutManager != null)
        {
            logoutManager.logout(this);
        }
        else
        {
            super.logout();
        }
    }
    
    /**
     * Logout this Session without calling the LogoutManager.
     */
    public synchronized void forceLogout()
    {
        super.logout();
    }
}
