/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.provider;

import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.Constants;
import org.apache.cocoon.environment.Context;

import org.ametys.runtime.config.Config;

/**
 * JCR Repository obtained through JNDI
 */
public class JNDIRepository extends AbstractRepository implements Initializable, Contextualizable, Component
{
    private Context _context;
    
    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException
    {
        _context = (Context) context.get(Constants.CONTEXT_ENVIRONMENT_CONTEXT);
    }
    
    public void initialize() throws Exception
    {
        // FIXME JNDI Repository should be compatible with safe mode to be able to run maintenance tasks
        // But currently it relies on the config.
        String name = Config.getInstance().getValue("org.ametys.plugins.repository.jndi");

        InitialContext ctx = null;
        try
        {
            ctx = new InitialContext();
            _delegate = (Repository) ctx.lookup(name);
            
            // Register the delegate repository in the context for the repository workspace.
            _context.setAttribute(CONTEXT_REPOSITORY_KEY, _delegate);
            _context.setAttribute(CONTEXT_CREDENTIALS_KEY, new SimpleCredentials("ametys", new char[]{}));
            _context.setAttribute(CONTEXT_IS_JNDI_KEY, true);
        }
        catch (NamingException e)
        {
            throw new ConfigurationException("Cannot lookup JNDI entry '" + name + "'", e);
        }
        finally
        {
            if (ctx != null)
            {
                try
                {
                    ctx.close();
                }
                catch (NamingException ignored)
                {
                    // Ignored
                }
            }
        }        
    }

    public Session login(String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException
    {
        return _delegate.login(new SimpleCredentials("ametys", new char[]{}), workspace);
    }
}
