/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.provider;

import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * Workspace selector using a context attribute for selecting
 * the workspace.
 */
public class RequestAttributeWorkspaceSelector extends AbstractLogEnabled implements Contextualizable, WorkspaceSelector
{
    private static final String __WORKSPACE_ATTRIBUTE = "jcr-workspace";
    
    private Context _context;

    @Override
    public void contextualize(Context context) throws ContextException
    {
        _context = context;
    }
    
    /**
     * Forces the workspace to use.
     * @param request the current request
     * @param workspaceName the workspace name.
     */
    public static void setForcedWorkspace(Request request, String workspaceName)
    {
        request.setAttribute(__WORKSPACE_ATTRIBUTE, workspaceName);
    }
    
    /**
     * Retrieves the workspace forced.
     * @param request the current request
     * @return the workspace forced or <code>null</code> for the default one.
     */
    public static String getForcedWorkspace(Request request)
    {
        return (String) request.getAttribute(__WORKSPACE_ATTRIBUTE);
    }

    @Override
    public String getWorkspace()
    {
        String workspace;
        try
        {
            Request request = (Request) _context.get(ContextHelper.CONTEXT_REQUEST_OBJECT);
            workspace = getForcedWorkspace(request);
        }
        catch (ContextException e)
        {
            // no current request
            getLogger().debug("No current request, using default workspace");
            
            return RepositoryConstants.DEFAULT_WORKSPACE;
        }
        
        if (workspace != null)
        {
            getLogger().debug("Using workspace: {}", workspace);
            
            return workspace;
        }
        
        getLogger().debug("Using default workspace");
        
        // No value, fall back to the default workspace
        return RepositoryConstants.DEFAULT_WORKSPACE;
    }
}
