/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;

import org.ametys.runtime.plugins.admin.jvmstatus.monitoring.sample.AbstractSampleManager;

/**
 * Monitoring active JCR sessions.
 */
public class SessionSampleManager extends AbstractSampleManager implements Serviceable
{
    private JackrabbitRepository _repository;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _repository = (JackrabbitRepository) manager.lookup(AbstractRepository.ROLE);
    } 
    
    @Override
    protected void _configureDatasources(RrdDef rrdDef)
    {
        _registerDatasources(rrdDef, "sessions", DsType.GAUGE, 0, Double.NaN);
    }

    @Override
    protected String _getGraphTitle()
    {
        return "JCR Sessions";
    }

    @Override
    protected Map<String, Object> _internalCollect(Sample sample) throws IOException
    {
        Map<String, Object> result = new HashMap<>();
        
        int sessions = _repository.getSessionCount();
        sample.setValue("sessions", sessions);
        result.put("sessions", sessions);
        return result;
    }
}
