/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.query.expression;

/**
 * Constructs an {@link Expression} corresponding to the double comparison with a metadata.
 */
public class DoubleExpression implements Expression
{
    private double _value;
    private Operator _operator;
    private MetadataExpression _metadata;

    /**
     * Creates the comparison Expression.
     * @param metadata the metadata name
     * @param operator the operator to make the comparison
     * @param value the double value
     */
    public DoubleExpression(String metadata, Operator operator, double value)
    {
        _value = value;
        _operator = operator;
        _metadata = new MetadataExpression(metadata);
    }
    
    /**
     * Creates the comparison Expression.
     * @param metadata the metadata name
     * @param operator the operator to make the comparison
     * @param value the double value
     * @param context the expression context
     */
    public DoubleExpression(String metadata, Operator operator, double value, ExpressionContext context)
    {
        _value = value;
        _operator = operator;
        _metadata = new MetadataExpression(metadata, context);
    }

    public String build()
    {
        return _metadata.build() + " " + _operator + " " + Double.toString(_value);
    }
}
