/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.query.expression;

/**
 * Handles an expression of a repository query.<br>
 * The formal view depends on the implementation of the query.
 */
public interface Expression
{
    /** The logical operator to use in xpath query */
    public enum LogicalOperator 
    {
        /** Logical operator AND */
        AND
        {
            @Override
            public String toString()
            {
                return " and ";
            }
        },
        /** Logical operator OR */
        OR
        {
            @Override
            public String toString()
            {
                return " or ";
            }
        }
    }
    
    /** Enumeration of available operators in {@link Expression} */
    public enum Operator 
    {
        /** Constant of test's operator for 'like' comparison. Works only for type String */
        WD 
        {
            @Override
            public String toString()
            {
                return "~";
            }
        },
        /** Constant of test's operator for 'less than' comparison */
        LT 
        {
            @Override
            public String toString()
            {
                return "<";
            }
        },
        /** Constant of test's operator for 'less than or equals to' comparison */
        LE 
        {
            @Override
            public String toString()
            {
                return "<=";
            }
        },
        /** Constant of test's operator for 'greater than' comparison */
        GT 
        {
            @Override
            public String toString()
            {
                return ">";
            }
        },
        /** Constant of test's operator for 'greater than or equals to' comparison */
        GE 
        {
            @Override
            public String toString()
            {
                return ">=";
            }
        },
        /** Constant of test's operator for 'equals to' comparison */
        EQ 
        {
            @Override
            public String toString()
            {
                return "=";
            }
        },
        /** Constant of test's operator for 'not equals to' comparison */
        NE 
        {
            @Override
            public String toString()
            {
                return "!=";
            }
        }
    }

    /**
     * Build the expression.
     * @return The XPath view of the expression.
     */
    public String build();
}
