/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.query.expression;

/**
 * Constructs an {@link Expression} corresponding to a full text search
 */
public class FullTextExpression implements Expression
{
    private String _value;
    private MetadataExpression _metadata;
    
    /**
     * Creates a full text Expression.
     * @param value the String value
     */
    public FullTextExpression (String value)
    {
        _value = value;
        _metadata = null;
    }
    
    /**
     * Creates a full text Expression.
     * @param metadata the metadata name
     * @param value the String value
     */
    public FullTextExpression (String metadata, String value)
    {
        _value = value;
        _metadata = new MetadataExpression(metadata);
    }
    
    @Override
    public String build()
    {
        if (_metadata != null)
        {
            return "jcr:contains(" + _metadata.build() + ", '" + _value.replaceAll("'", "''") + "')";
        }
        else
        {
            return "jcr:contains(., '" + _value.replaceAll("'", "''") + "')";
        }
    }
}
