/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.query.expression;

/**
 * Constructs an {@link Expression} corresponding to the long comparison with a metadata.
 */
public class LongExpression implements Expression
{
    private long _value;
    private Operator _operator;
    private MetadataExpression _metadata;

    /**
     * Creates the comparison Expression.
     * @param metadata the metadata name
     * @param operator the operator to make the comparison
     * @param value the long value
     */
    public LongExpression(String metadata, Operator operator, long value)
    {
        _value = value;
        _operator = operator;
        _metadata = new MetadataExpression(metadata);
    }
    
    /**
     * Creates the comparison Expression.
     * @param metadata the metadata name
     * @param operator the operator to make the comparison
     * @param value the long value
     * @param context the expression context
     */
    public LongExpression(String metadata, Operator operator, long value, ExpressionContext context)
    {
        _value = value;
        _operator = operator;
        _metadata = new MetadataExpression(metadata, context);
    }

    public String build()
    {
        return _metadata.build() + " " + _operator + " " + Long.toString(_value);
    }
}
