/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.query.expression;

import org.ametys.plugins.repository.RepositoryConstants;

/**
 * Constructs an {@link Expression} testing the existence of a metadata.
 */
public class MetadataExpression implements Expression
{
    private String _metadata;
    private String _path;
    private ExpressionContext _context;

    /**
     * Creates the comparison Expression.
     * @param metadata the metadata name
     */
    public MetadataExpression(String metadata)
    {
        this(metadata, ExpressionContext.newInstance());
    }
    
    /**
     * Creates the comparison Expression.
     * @param metadata the metadata name
     * @param context the context of the expression
     */
    public MetadataExpression(String metadata, ExpressionContext context)
    {
        int index = metadata.lastIndexOf('/');
        boolean isComposite = index != -1;
        _path = isComposite ? metadata.substring(0, index) : null;
        _metadata = isComposite ? metadata.substring(index + 1) : metadata;
        _context = context;
    }
    
    public String build()
    {
        StringBuilder buff = new StringBuilder();
        String repositoryPrefix = _context.internal() ? RepositoryConstants.NAMESPACE_PREFIX_INTERNAL : RepositoryConstants.NAMESPACE_PREFIX;
        
        if (_context.unversioned())
        {
            buff.append(RepositoryConstants.NAMESPACE_PREFIX_INTERNAL).append(":unversioned/");
        }
        if (_path != null)
        {
            String[] parts = _path.split("/");
            for (String part : parts)
            {
                if ("*".equals(part))
                {
                    buff.append(part).append('/');
                }
                else
                {
                    buff.append(repositoryPrefix).append(':').append(part).append('/');
                }
                
            }
        }
        buff.append('@').append(repositoryPrefix).append(':').append(_metadata);
        
        return buff.toString();
    }
}
