/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.query.expression;

import java.util.List;

/**
 * Constructs an {@link Expression} corresponding to a logical "or" operator between several {@link Expression}.
 */
public class OrExpression extends AbstractLogicalExpression
{
    /**
     * Creates the "or" Expression.
     * @param exprs the operands
     */
    public OrExpression(Expression ... exprs)
    {
        super(exprs);
    }
    
    /**
     * Creates the "or" Expression.
     * @param exprs the operands
     */
    public OrExpression(List<Expression> exprs)
    {
        super(exprs);
    }
    
    @Override
    protected LogicalOperator getLogicalOperator()
    {
        return LogicalOperator.OR;
    }
}
