/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.repository.query.expression;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.virtual.VirtualAmetysObjectFactory;

/**
 * Expression matching {@link AmetysObject}s holding a link to a {@link VirtualAmetysObjectFactory}.
 */
public class VirtualFactoryExpression implements Expression
{
    private String _value;
    
    /**
     * Creates the comparison Expression.
     * @param value the metadata value
     */
    public VirtualFactoryExpression(String value)
    {
        _value = value;
    }
    
    public String build()
    {
        return '@' + AmetysObjectResolver.VIRTUAL_PROPERTY + " = '" + _value.replaceAll("'", "''") + "'";
    }
}
