/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.rights;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.right.RightAssignmentContext;
import org.ametys.plugins.repository.ACLAmetysObject;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.PluginAware;

/**
 * Private {@link RightAssignmentContext} for {@link ACLAmetysObject}.<br>
 * This implementation can be used to get a {@link ACLAmetysObject} from a JS context.<br>
 * It is not supposed to be available to get or set assignments.
 */
public class ACLAmetysObjectRightAssignmentContext implements RightAssignmentContext, Serviceable, PluginAware
{
    /** The id of this right context */
    public static final String ID = "right.assignment.context.ametysobject";
    
    /** The Ametys object resolver */
    protected AmetysObjectResolver _resolver;

    private String _pluginName;

    private String _id;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public void setPluginInfo(String pluginName, String featureName, String id)
    {
        _id = id;
        _pluginName = pluginName;
    }
    
    public String getId()
    {
        return _id;
    }
    
    public boolean isPrivate()
    {
        return true;
    }
    
    public Object convertJSContext(Object jsContext)
    {
        if (jsContext instanceof String)
        {
            AmetysObject ao = _resolver.resolveById((String) jsContext);
            if (ao instanceof ACLAmetysObject)
            {
                return ao;
            }
        }
        return null;
    }

    public String getContextIdentifier(Object context)
    {
        return ((AmetysObject) context).getId();
    }

    public Set<Object> getParentContexts(Object context)
    {
        return null;
    }

    public List<Object> getRootContexts(Map<String, Object> contextParameters)
    {
        return List.of();
    }

    public List<Script> getScripts(Map<String, Object> contextParameters)
    {
        return List.of();
    }

    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        return List.of();
    }

    public Map<String, String> getRights(Map<String, Object> contextParameters)
    {
        return Map.of();
    }

    public String getPluginName()
    {
        return _pluginName;
    }

    public Map<String, List<String>> getDependencies()
    {
        return Map.of();
    }

}
