/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.root;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;

/**
 * Special {@link AmetysObjectFactory} handling only the root {@link AmetysObject}.
 */
public final class RootAmetysObjectFactory extends DefaultTraversableAmetysObjectFactory
{
    @Override
    public DefaultTraversableAmetysObject getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        if (StringUtils.isNotEmpty(parentPath))
        {
            throw new AmetysRepositoryException("The root object can't have a not empty parent path");
        }
        
        try
        {
            if (!AmetysObjectResolver.ROOT_TYPE.equals(node.getPrimaryNodeType().getName()) || !"/ametys:root".equals(node.getPath()))
            {
                throw new AmetysRepositoryException("The root object must be located at /ametys:root and be of type ametys:root");
            }
        }
        catch (RepositoryException e) 
        {
            throw new AmetysRepositoryException("An error occured testing root node", e);
        }
        
        return new RootAmetysObject(node, this);
    }
}
