/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.tag;

import java.util.Set;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;

/**
 * {@link AmetysObject} which is aware of tagging.
 */
public interface TagAwareAmetysObject extends AmetysObject
{
    /**
     * Retrieves current tags.
     * @return the current tags.
     * @throws AmetysRepositoryException if an error occurs.
     */
    Set<String> getTags() throws AmetysRepositoryException;
}
