/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.trash;

import java.util.List;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ItemParserHelper.ConfigurationAndPluginName;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;

/**
 * A configurable implementation of a trash element type.
 * the {@code message-target-type} is not mandatory but you should override the {@link #getMessageTargetType} method
 * if you don't provide
 */
public abstract class AbstractStaticTrashElementType extends AbstractLogEnabled implements TrashElementType, PluginAware, Configurable
{
    private String _id;
    private int _priority;
    private String _pluginName;
    private I18nizableText _label;
    private String _messageTargetType;

    public void setPluginInfo(String pluginName, String featureName, String id)
    {
        _id = id;
        _pluginName = pluginName;
    }
    
    public void configure(Configuration configuration) throws ConfigurationException
    {
        _priority = configuration.getChild("priority").getValueAsInteger(1000);
        _label = I18nizableText.parseI18nizableText(configuration.getChild("label"), "plugin." + _pluginName);
        _messageTargetType = configuration.getChild("message-target-type").getValue(null);
    }
    
    public int getPriority()
    {
        return _priority;
    }

    public String getId()
    {
        return _id;
    }

    public I18nizableText getLabel()
    {
        return _label;
    }

    public String getMessageTargetType(TrashableAmetysObject object)
    {
        return _messageTargetType;
    }
    
    public List<ConfigurationAndPluginName> getAdditionalModelItemsConfigurationAndPluginName()
    {
        return List.of();
    }
}
