/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.trash;

/**
 * Interface for a component able to instantiate a {@link TrashElement}
 */
public interface TrashElementDAO
{
    /** The avalon role */
    public static final String ROLE = TrashElementDAO.class.getName();

    /**
     * Instantiate a new trash element where the ametys object can store
     * data to be able to restore itself later
     * @param ametysObject the ametys object to trash
     * @param title the title of the element
     * @return the trash element
     */
    public TrashElement createTrashElement(TrashableAmetysObject ametysObject, String title);
}
