/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.trash;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * Enumerator for trash element types.
 */
public class TrashElementTypeEnumerator implements Enumerator<String>, Serviceable, Component
{
    /** The avalon role */
    public static final String ROLE = TrashElementTypeEnumerator.class.getName();
    
    /** The trash element type extension point */
    protected TrashElementTypeExtensionPoint _trashElementTypeEP;

    public void service(ServiceManager manager) throws ServiceException
    {
        _trashElementTypeEP = (TrashElementTypeExtensionPoint) manager.lookup(TrashElementTypeExtensionPoint.ROLE);
    }
    
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        Map<String, I18nizableText> result = new HashMap<>();
        for (String id :_trashElementTypeEP.getExtensionsIds())
        {
            TrashElementType trashType = _trashElementTypeEP.getExtension(id);
            result.put(id, trashType.getLabel());
        }
        return result;
    }
    
    public I18nizableText getEntry(String value) throws Exception
    {
        return _trashElementTypeEP.hasExtension(value) ? _trashElementTypeEP.getExtension(value).getLabel() : null;
    }
}
