/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.trash;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;

/**
 * {@link AmetysObject} which can be moved to trash or restored.
 */
public interface TrashableAmetysObject extends JCRAmetysObject
{
    /**
     * Move this {@link AmetysObject} to the trash.
     * @return the created trash element that represents the object in the trash
     */
    public TrashElement moveToTrash();
    
    /**
     * Restore this {@link AmetysObject} from the trash.
     * @implNote when invoked on a object that is not in the trash, this method should have no effect
     * when invoked on a object in the trash, it should restore the Ametys object in the default workspace and return it.
     * 
     * @return the restored ametys object
     * @throws UnknownParentException if it's not possible to determine a location to restore the object
     */
    public TrashableAmetysObject restoreFromTrash() throws UnknownParentException;
}
