/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.version;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;


/**
 * {@link AmetysObject} with versioning capabilities.
 */
public interface VersionableAmetysObject extends VersionAwareAmetysObject
{
    /**
     * Persists the current version of this {@link AmetysObject}
     * @throws AmetysRepositoryException if a problem occurs
     */
    public void checkpoint() throws AmetysRepositoryException;

    /**
     * Restore data from the specified label.<br>
     * @param label the label
     * @throws UnknownAmetysObjectException if the label does not correspond to any revision
     * @throws AmetysRepositoryException if a problem occurs
     */
    public void restoreFromLabel(String label)  throws UnknownAmetysObjectException, AmetysRepositoryException;

    /**
     * Restore data from the specified revision.<br>
     * @param revision the revision
     * @throws UnknownAmetysObjectException if the revision does not exist
     * @throws AmetysRepositoryException if a problem occurs
     */
    public void restoreFromRevision(String revision)  throws UnknownAmetysObjectException, AmetysRepositoryException;
    
    /**
     * Add a label on this object.
     * @param label the label to add.
     * @param moveIfPresent what to do if the content already has this label : move it to the current revision if <code>true</code>, keep it unchanged if <code>false</code>.
     * @throws AmetysRepositoryException if some problem arises.
     */
    public void addLabel(String label, boolean moveIfPresent) throws AmetysRepositoryException;

    /**
     * Remove a label from this object.<br>
     * If the label doesn't exist, it is silently ignored.
     * @param label the label to remove
     * @throws AmetysRepositoryException if some problem arises.
     */
    public void removeLabel(String label) throws AmetysRepositoryException;
}
