/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.virtual;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;

/**
 * {@link AmetysObjectFactory} for handling "virtual" objects, in that they did
 * not rely directly to the JCR storage.<br>
 * Such factory is bounded to an object through a particular property in the JCR tree.<br>
 * Virtual {@link AmetysObject} handled by a {@link VirtualAmetysObjectFactory} are considered as children of the {@link JCRAmetysObject} corresponding to the JCR Node holding that property.
 * @param <A> the actual type of {@link AmetysObject}s
 */
public interface VirtualAmetysObjectFactory<A extends AmetysObject> extends AmetysObjectFactory<A>
{
    /**
     * Returns the "root" objects of this virtual factory, hosted in the Ametys
     * hierarchy under a {@link TraversableAmetysObject}, which is backed by a
     * concrete JCR Node.
     * @param parent the {@link JCRAmetysObject} "hosting" this factory.
     * @return the root objects of this virtual factory.
     */
    AmetysObjectIterable<A> getChildren(JCRAmetysObject parent);
    
    /**
     * Returns a named {@link AmetysObject}.
     * @param parent the {@link JCRAmetysObject} "hosting" this factory.
     * @param childName the name of the virtual child.
     * @return the corresponding {@link AmetysObject}.
     */
    A getChild(JCRAmetysObject parent, String childName);
    
    /**
     * Returns true if the named {@link AmetysObject} exists.
     * @param parent the {@link JCRAmetysObject} "hosting" this factory.
     * @param childName the name of the virtual child.
     * @return true if the named {@link AmetysObject} exists.
     */
    boolean hasChild(JCRAmetysObject parent, String childName);
}
