/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.repository.workspace;

import java.io.IOException;
import java.util.Iterator;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Generate a list of path from an XPath query
 */
public class QueryLogicResultGenerator extends AbstractGenerator implements Serviceable
{
    private AmetysObjectResolver _resolver;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    public void generate() throws IOException, SAXException, ProcessingException
    {
        
        if (getLogger().isInfoEnabled())
        {
            getLogger().info("Trying to generate results for a XPath query (logic view)");
        }
        
        contentHandler.startDocument();
        
        XMLUtils.startElement(contentHandler, "resultList");
        
        String query = parameters.getParameter("query", "");
        
        if (StringUtils.isNotBlank(query))
        {
            try
            {
                _populateQueryResult(query);
            }
            catch (Exception e)
            {
                getLogger().error("Unable to execute logic query '" + query + "'", e);
                XMLUtils.createElement(contentHandler, "error", e.toString());
            }
        }
        
        XMLUtils.endElement(contentHandler, "resultList");
        
        contentHandler.endDocument();
    }


    private void _populateQueryResult(String query) throws SAXException
    {
        AmetysObjectIterable<AmetysObject> itResults = _resolver.query(query);
        Iterator<AmetysObject> it = itResults.iterator();
        
        while (it.hasNext())
        {
            AmetysObject ao = it.next();
            
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("id", ao.getId());
            attr.addCDATAAttribute("path", ao.getPath());
            attr.addCDATAAttribute("name", ao.getName());
            XMLUtils.createElement(contentHandler, "result", attr);
        }
    }
}
