/*
 *  Copyright 2009 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.workspaces.repository;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.ametys.plugins.repository.script.RepositoryScriptHelper;

/**
 * Helper methods to manipulating JCR nodes in JCR repository console
 * 
 * @deprecated Use {@link RepositoryScriptHelper} instead
 * This helper (moved from JCR to Repository) has been kept only to maintained backward compatibility with old
 * script using directly the fully qualified name of this class instead of Repository.helper
 */
@Deprecated
public final class ConsoleHelper
{
    private ConsoleHelper()
    {
        // Utility class
    }
    
    /**
     * Helper to set ambiguous object values from a node property
     * @param node the node
     * @param name the property name
     * @param values the property values as String[] or Value[]
     * @throws RepositoryException if an error occurred
     */
    public static void setProperty(Node node, String name, Object values) throws RepositoryException
    {
        RepositoryScriptHelper.setProperty(node, name, values);
    }
    
    /**
     * Helper to convert a single-valued property to a multi-valued property.
     * This helper checks that property exists and that it is not already multiple.
     * @param node the node holding the property
     * @param propertyName the property's name
     * @return true if changes was made
     * @throws RepositoryException if an error occurred
     */
    public static boolean convertSingleToMultipleProperty (Node node, String propertyName) throws RepositoryException
    {
        return RepositoryScriptHelper.convertSingleToMultipleProperty(node, propertyName);
    }
}
