/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core;

import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.PluginsManager;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;

public final class DevMode {
    public static final String SESSION_ATTRIBUTE_DEVMODE = DevMode.class.toString() + "$DevMode";
    public static final String REQUEST_PARAM_FORCE_DEVMODE = "debug.mode";

    private DevMode() {
    }

    public static DEVMODE getDeveloperMode() {
        return DevMode.getDeveloperMode(null);
    }

    public static DEVMODE getDeveloperMode(Request request) {
        if (request != null) {
            Object devMode;
            Session session = request.getSession(false);
            String forceDevMode = request.getParameter(REQUEST_PARAM_FORCE_DEVMODE);
            if (forceDevMode != null) {
                devMode = DEVMODE.createsFromString(forceDevMode);
                if (devMode == null) {
                    if (session != null) {
                        session.removeAttribute(SESSION_ATTRIBUTE_DEVMODE);
                    }
                } else {
                    if (session != null) {
                        session.setAttribute(SESSION_ATTRIBUTE_DEVMODE, (Object)devMode.toString());
                    }
                    return devMode;
                }
            }
            if (session != null && (devMode = (String)session.getAttribute(SESSION_ATTRIBUTE_DEVMODE)) != null) {
                return DEVMODE.createsFromString((String)devMode);
            }
        }
        if (PluginsManager.getInstance().isSafeMode()) {
            return DEVMODE.DEVELOPMENT;
        }
        return Config.getInstance().getValue("runtime.mode.dev", true, false) != false ? DEVMODE.DEVELOPMENT : DEVMODE.PRODUCTION;
    }

    public static enum DEVMODE {
        SUPER_DEVELOPPMENT("super"),
        DEVELOPMENT("true"),
        PRODUCTION("false");

        private String _value;

        private DEVMODE(String value) {
            this._value = value;
        }

        public String toString() {
            return this._value;
        }

        public static DEVMODE createsFromString(String size) {
            for (DEVMODE v : DEVMODE.values()) {
                if (!v.toString().equals(size)) continue;
                return v;
            }
            return null;
        }
    }
}

