/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.authentication;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.CredentialProvider;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.WeakPasswordException;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.UserStatusManager;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.core.impl.authentication.FormCredentialProvider;
import org.ametys.plugins.core.user.UserDAO;
import org.ametys.plugins.core.user.management.UserPasswordManager;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.ametys.runtime.maintenance.MaintenanceAction;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class AuthenticateAction
extends ServiceableAction
implements ThreadSafe,
Initializable {
    public static final String REQUEST_ATTRIBUTE_INTERNAL_ALLOWED = "Runtime:InternalAllowedRequest";
    public static final String REQUEST_ATTRIBUTE_GRANTED = "Runtime:GrantedRequest";
    public static final String REQUEST_ATTRIBUTE_AVAILABLE_USER_POPULATIONS_LIST = "Runtime:UserPopulationsList";
    public static final String REQUEST_ATTRIBUTE_USER_POPULATION_ID = "Runtime:CurrentUserPopulationId";
    public static final String REQUEST_ATTRIBUTE_LOGIN_URL = "Runtime:RequestLoginURL";
    public static final String SESSION_USERIDENTITY = "Runtime:UserIdentity";
    public static final String REQUEST_PARAMETER_POPULATION_NAME = "UserPopulation";
    public static final String REQUEST_PARAMETER_CREDENTIALPROVIDER_INDEX = "CredentialProviderIndex";
    public static final String REQUEST_PARAMETER_NONBLOCING = "NonBlocking";
    public static final String REQUEST_ATTRIBUTE_AUTHENTICATED = "Runtime:RequestAuthenticated";
    public static final String REQUEST_PARAMETER_TOKEN = "token";
    public static final String REQUEST_PARAMETER_TOKEN_CONTEXT = "tokenContext";
    public static final String HEADER_TOKEN = "X-Ametys-Token";
    protected static final String PARAMETERS_PARAMETER_TOKEN = "token";
    protected static final String PARAMETERS_PARAMETER_TOKEN_CONTEXT = "tokenContext";
    protected static final String REQUEST_ATTRIBUTE_CREDENTIAL_PROVIDER_LIST = "Runtime:RequestListCredentialProvider";
    protected static final String REQUEST_ATTRIBUTE_CREDENTIAL_PROVIDER_INDEX = "Runtime:RequestCredentialProviderIndex";
    protected static final String REQUEST_ATTRIBUTE_SHOULD_DISPLAY_USER_POPULATIONS_LIST = "Runtime:UserPopulationsListDisplay";
    protected static final String REQUEST_ATTRIBUTE_INVALID_POPULATION = "Runtime:RequestInvalidPopulation";
    protected static final String REQUEST_ATTRIBUTE_CONTEXTS = "Runtime:Contexts";
    protected static final String SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX = "Runtime:ConnectingCredentialProviderIndex";
    protected static final String SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX_LASTBLOCKINGKNOWN = "Runtime:ConnectingCredentialProviderIndexLastKnown";
    protected static final String SESSION_CONNECTING_CREDENTIALPROVIDER_MODE = "Runtime:ConnectingCredentialProviderMode";
    protected static final String SESSION_CONNECTING_USERPOPULATION_ID = "Runtime:ConnectingUserPopulationId";
    protected static final String SESSION_CREDENTIALPROVIDER = "Runtime:CredentialProvider";
    protected static final String SESSION_CREDENTIALPROVIDER_MODE = "Runtime:CredentialProviderMode";
    protected static final String SITEMAP_PARAMETER_TOKEN_MODE = "token-mode";
    protected UserPopulationDAO _userPopulationDAO;
    protected UserManager _userManager;
    protected PopulationContextHelper _populationContextHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected Collection<Pattern> _acceptedUrlPatterns = Arrays.asList(Pattern.compile("^plugins/core/authenticate/[0-9]+$"), Pattern.compile("^plugins/core/reset-password.html$"));
    protected AuthenticationTokenManager _authenticateTokenManager;
    protected ObservationManager _observationManager;
    protected UserPasswordManager _userPasswordManager;
    protected UserStatusManager _userStatusManager;

    public void initialize() throws Exception {
        this._userPopulationDAO = (UserPopulationDAO)this.manager.lookup(UserPopulationDAO.ROLE);
        this._userManager = (UserManager)this.manager.lookup(UserManager.ROLE);
        this._populationContextHelper = (PopulationContextHelper)this.manager.lookup(PopulationContextHelper.ROLE);
        this._userStatusManager = (UserStatusManager)this.manager.lookup(UserStatusManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)this.manager.lookup(CurrentUserProvider.ROLE);
        try {
            this._userPasswordManager = (UserPasswordManager)this.manager.lookup(UserPasswordManager.ROLE);
            this._authenticateTokenManager = (AuthenticationTokenManager)this.manager.lookup(AuthenticationTokenManager.ROLE);
            this._observationManager = (ObservationManager)((Object)this.manager.lookup(ObservationManager.ROLE));
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        CredentialProvider runningCredentialProvider;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (this._preFlightCheck(redirector, resolver, objectModel, source, parameters) || this._handleAuthenticationToken(request, parameters)) {
            request.setAttribute(REQUEST_ATTRIBUTE_AUTHENTICATED, (Object)"true");
            return EMPTY_MAP;
        }
        if (this._getTokenMode(parameters) != TOKEN_MODE.DEFAULT) {
            if (this._getTokenMode(parameters) == TOKEN_MODE.ALLOW_ANONYMOUS) {
                request.setAttribute(REQUEST_ATTRIBUTE_AUTHENTICATED, (Object)"true");
            }
            return null;
        }
        request.setAttribute(REQUEST_ATTRIBUTE_AUTHENTICATED, (Object)"true");
        ArrayList<UserPopulation> chosenUserPopulations = new ArrayList<UserPopulation>();
        ArrayList<CredentialProvider> credentialProviders = new ArrayList<CredentialProvider>();
        if (!this._prepareUserPopulationsAndCredentialProviders(request, parameters, redirector, chosenUserPopulations, credentialProviders)) {
            return EMPTY_MAP;
        }
        int runningCredentialProviderIndex = this._getCurrentCredentialProviderIndex(request, credentialProviders);
        request.setAttribute(REQUEST_ATTRIBUTE_CREDENTIAL_PROVIDER_INDEX, (Object)runningCredentialProviderIndex);
        request.setAttribute(REQUEST_ATTRIBUTE_LOGIN_URL, (Object)this.getLoginURL(request));
        if (!this._isCurrentCredentialProviderInBlockingMode(request)) {
            for (runningCredentialProviderIndex = Math.max(0, runningCredentialProviderIndex); runningCredentialProviderIndex < credentialProviders.size(); ++runningCredentialProviderIndex) {
                runningCredentialProvider = (CredentialProvider)credentialProviders.get(runningCredentialProviderIndex);
                if (!this._process(request, false, runningCredentialProvider, runningCredentialProviderIndex, redirector, chosenUserPopulations)) continue;
                return EMPTY_MAP;
            }
            runningCredentialProviderIndex = -1;
        }
        this._saveLastKnownBlockingCredentialProvider(request, runningCredentialProviderIndex);
        if (this._shouldRunFirstBlockingCredentialProvider(runningCredentialProviderIndex, credentialProviders, request, chosenUserPopulations)) {
            CredentialProvider credentialProvider = runningCredentialProvider = runningCredentialProviderIndex == -1 ? this._getFirstBlockingCredentialProvider(credentialProviders) : (CredentialProvider)credentialProviders.get(runningCredentialProviderIndex);
            if (this._process(request, true, runningCredentialProvider, runningCredentialProviderIndex, redirector, chosenUserPopulations)) {
                return EMPTY_MAP;
            }
            throw new AuthorizationRequiredException();
        }
        Integer formerRunningCredentialProviderIndex = (Integer)request.getSession(true).getAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX_LASTBLOCKINGKNOWN);
        if (formerRunningCredentialProviderIndex != null && ((CredentialProvider)credentialProviders.get(formerRunningCredentialProviderIndex)).grantAnonymousRequest(true)) {
            request.setAttribute(REQUEST_ATTRIBUTE_GRANTED, (Object)true);
            this._saveConnectingStateToSession(request, -1, true);
            return EMPTY_MAP;
        }
        return this._displayBlockingList(redirector, request, credentialProviders);
    }

    protected boolean _preFlightCheck(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        return this._handleLogout(redirector, objectModel, source, parameters) || this._internalRequest(request) || this._acceptedUrl(request) || this._validateCurrentlyConnectedUser(request, redirector, parameters) || redirector.hasRedirected();
    }

    protected boolean _handleAuthenticationToken(Request request, Parameters parameters) {
        String context;
        UserIdentity userIdentity;
        String token = request.getHeader(HEADER_TOKEN);
        if (StringUtils.isBlank((CharSequence)token)) {
            token = parameters.getParameter("token", this._getTokenFromRequest(request));
        }
        if (StringUtils.isNotBlank((CharSequence)token) && (userIdentity = this._validateToken(token, context = parameters.getParameter("tokenContext", null))) != null) {
            this._setUserIdentityInSession(request, userIdentity, new UserDAO.ImpersonateCredentialProvider(), true);
            this._validateCurrentlyConnectedUserIsInAuthorizedPopulation(userIdentity, request, parameters);
            this._userStatusManager.updateConnectionDate(userIdentity);
            Map<String, Object> tokenArgs = Map.of("user", userIdentity);
            ForensicLogger.info("authentication.token", tokenArgs, userIdentity);
            return true;
        }
        return false;
    }

    protected String _getTokenFromRequest(Request request) {
        return request.getParameter("token");
    }

    protected UserIdentity _validateToken(String token, String context) {
        return this._authenticateTokenManager != null ? this._authenticateTokenManager.validateToken(token, context) : null;
    }

    private TOKEN_MODE _getTokenMode(Parameters parameters) {
        return TOKEN_MODE.valueOf(parameters.getParameter(SITEMAP_PARAMETER_TOKEN_MODE, TOKEN_MODE.DEFAULT.toString()).toUpperCase());
    }

    private void _saveLastKnownBlockingCredentialProvider(Request request, int runningCredentialProviderIndex) {
        if (runningCredentialProviderIndex != -1) {
            request.getSession(true).setAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX_LASTBLOCKINGKNOWN, (Object)runningCredentialProviderIndex);
        }
    }

    private Map _displayBlockingList(Redirector redirector, Request request, List<CredentialProvider> credentialProviders) throws IOException, ProcessingException, AuthorizationRequiredException {
        if (credentialProviders.stream().filter(cp -> cp instanceof BlockingCredentialProvider).findFirst().isPresent()) {
            this._saveConnectingStateToSession(request, -1, true);
            redirector.redirect(false, this.getLoginURL(request));
            return EMPTY_MAP;
        }
        throw new AuthorizationRequiredException();
    }

    private boolean _shouldRunFirstBlockingCredentialProvider(int runningCredentialProviderIndex, List<CredentialProvider> credentialProviders, Request request, List<UserPopulation> chosenUserPopulations) {
        return runningCredentialProviderIndex >= 0 || credentialProviders.stream().filter(cp -> cp instanceof BlockingCredentialProvider).count() == 1L && (((List)request.getAttribute(REQUEST_ATTRIBUTE_AVAILABLE_USER_POPULATIONS_LIST)).size() == chosenUserPopulations.size() || this._getFirstBlockingCredentialProvider(credentialProviders).requiresNewWindow());
    }

    private BlockingCredentialProvider _getFirstBlockingCredentialProvider(List<CredentialProvider> credentialProviders) {
        Optional<CredentialProvider> findFirst = credentialProviders.stream().filter(cp -> cp instanceof BlockingCredentialProvider).findFirst();
        if (findFirst.isPresent()) {
            return (BlockingCredentialProvider)findFirst.get();
        }
        return null;
    }

    protected boolean _prepareUserPopulationsAndCredentialProviders(Request request, Parameters parameters, Redirector redirector, List<UserPopulation> chosenUserPopulations, List<CredentialProvider> credentialProviders) throws ProcessingException, IOException {
        List<String> contexts = this._getContexts(request, parameters);
        request.setAttribute(REQUEST_ATTRIBUTE_CONTEXTS, contexts);
        List<UserPopulation> availableUserPopulations = this._getAvailableUserPopulationsIds(request, contexts).stream().map(this._userPopulationDAO::getUserPopulation).collect(Collectors.toList());
        request.setAttribute(REQUEST_ATTRIBUTE_AVAILABLE_USER_POPULATIONS_LIST, availableUserPopulations);
        String userPopulationId = this._getChosenUserPopulationId(request, availableUserPopulations);
        request.setAttribute(REQUEST_ATTRIBUTE_USER_POPULATION_ID, (Object)userPopulationId);
        chosenUserPopulations.addAll(userPopulationId == null ? availableUserPopulations : Collections.singletonList(this._userPopulationDAO.getUserPopulation(userPopulationId)));
        if (chosenUserPopulations.size() == 0) {
            String redirection = parameters.getParameter("nocontext-redirection", null);
            if (redirection == null) {
                throw new IllegalStateException("There is no populations available for contexts '" + StringUtils.join(contexts, (String)"', '") + "'");
            }
            redirector.redirect(false, redirection);
            return false;
        }
        boolean availableCredentialProviders = this._hasCredentialProviders(chosenUserPopulations);
        request.setAttribute(REQUEST_ATTRIBUTE_CREDENTIAL_PROVIDER_LIST, (Object)availableCredentialProviders);
        if (!availableCredentialProviders) {
            request.setAttribute(REQUEST_ATTRIBUTE_SHOULD_DISPLAY_USER_POPULATIONS_LIST, (Object)true);
            AuthenticateAction._resetConnectingStateToSession(request);
            if (redirector != null) {
                redirector.redirect(false, this.getLoginURL(request));
            }
            return false;
        }
        credentialProviders.addAll(chosenUserPopulations.get(0).getCredentialProviders());
        if (credentialProviders.size() == 0) {
            throw new IllegalStateException("There is no populations credential provider available for contexts '" + StringUtils.join(contexts, (String)"', '") + "'");
        }
        request.setAttribute(REQUEST_ATTRIBUTE_SHOULD_DISPLAY_USER_POPULATIONS_LIST, (Object)(userPopulationId == null || this._hasCredentialProviders(availableUserPopulations) || credentialProviders.size() == 1 && !credentialProviders.stream().filter(cp -> cp instanceof FormCredentialProvider).findAny().isPresent() ? 1 : 0));
        return true;
    }

    protected String getLoginURL(Request request) {
        return this.getLoginURLParameters(request, "cocoon://_plugins/core/login.html");
    }

    protected String getLoginURLParameters(Request request, String baseURL) {
        boolean availableCredentialProviders;
        String chosenPopulationId;
        ArrayList<CallSite> parameters = new ArrayList<CallSite>();
        Boolean invalidPopulationIds = (Boolean)request.getAttribute(REQUEST_ATTRIBUTE_INVALID_POPULATION);
        parameters.add((CallSite)((Object)("invalidPopulationIds=" + (invalidPopulationIds == Boolean.TRUE ? "true" : "false"))));
        boolean shouldDisplayUserPopulationsList = (Boolean)request.getAttribute(REQUEST_ATTRIBUTE_SHOULD_DISPLAY_USER_POPULATIONS_LIST);
        parameters.add((CallSite)((Object)("shouldDisplayUserPopulationsList=" + (shouldDisplayUserPopulationsList ? "true" : "false"))));
        List usersPopulations = (List)request.getAttribute(REQUEST_ATTRIBUTE_AVAILABLE_USER_POPULATIONS_LIST);
        if (usersPopulations != null) {
            parameters.add((CallSite)((Object)("usersPopulations=" + URIUtils.encodeParameter(usersPopulations.stream().map(UserPopulation::getId).collect(Collectors.joining(","))))));
        }
        if ((chosenPopulationId = (String)request.getAttribute(REQUEST_ATTRIBUTE_USER_POPULATION_ID)) != null) {
            parameters.add((CallSite)((Object)("chosenPopulationId=" + URIUtils.encodeParameter(chosenPopulationId))));
        }
        parameters.add((CallSite)((Object)("availableCredentialProviders=" + ((availableCredentialProviders = ((Boolean)request.getAttribute(REQUEST_ATTRIBUTE_CREDENTIAL_PROVIDER_LIST)).booleanValue()) ? "true" : "false"))));
        Integer credentialProviderIndex = (Integer)request.getAttribute(REQUEST_ATTRIBUTE_CREDENTIAL_PROVIDER_INDEX);
        parameters.add((CallSite)((Object)("credentialProviderIndex=" + String.valueOf(credentialProviderIndex != null ? credentialProviderIndex : -1))));
        List contexts = (List)request.getAttribute(REQUEST_ATTRIBUTE_CONTEXTS);
        parameters.add((CallSite)((Object)("contexts=" + URIUtils.encodeParameter(StringUtils.join((Iterable)contexts, (String)",")))));
        return baseURL + (baseURL.contains("?") ? "&" : "?") + StringUtils.join(parameters, (String)"&");
    }

    protected String getLogoutURL(Request request) {
        return "cocoon://_plugins/core/logout.html";
    }

    protected boolean _hasCredentialProviders(List<UserPopulation> userPopulations) {
        return userPopulations.size() == 1 || userPopulations.stream().map(UserPopulation::getCredentialProviders).distinct().count() == 1L && userPopulations.stream().map(this::_needsResetLinkOnFormCredential).distinct().count() == 1L;
    }

    private boolean _needsResetLinkOnFormCredential(UserPopulation userPopulation) {
        if (userPopulation.getCredentialProviders().stream().filter(FormCredentialProvider.class::isInstance).map(FormCredentialProvider.class::cast).map(FormCredentialProvider::displayResetLink).findAny().orElse(false).booleanValue()) {
            return userPopulation.getUserDirectories().stream().anyMatch(ModifiableUserDirectory.class::isInstance);
        }
        return false;
    }

    protected Set<String> _getAvailableUserPopulationsIds(Request request, List<String> contexts) {
        return this._populationContextHelper.getUserPopulationsOnContexts(contexts, false, false);
    }

    protected String _getChosenUserPopulationId(Request request, List<UserPopulation> availableUserPopulations) {
        Session session;
        String userPopulationId = request.getParameter(REQUEST_PARAMETER_POPULATION_NAME);
        if (userPopulationId == null && (session = request.getSession(false)) != null) {
            userPopulationId = (String)session.getAttribute(SESSION_CONNECTING_USERPOPULATION_ID);
        }
        if (StringUtils.isNotBlank((CharSequence)userPopulationId)) {
            String finalUserPopulationId = userPopulationId;
            if (availableUserPopulations.stream().anyMatch(userPopulation -> userPopulation.getId().equals(finalUserPopulationId))) {
                return userPopulationId;
            }
            request.setAttribute(REQUEST_ATTRIBUTE_INVALID_POPULATION, (Object)true);
        }
        return null;
    }

    protected boolean _process(Request request, boolean runningBlockingkMode, CredentialProvider runningCredentialProvider, int runningCredentialProviderIndex, Redirector redirector, List<UserPopulation> userPopulations) throws Exception {
        boolean existingSession = request.getSession(false) != null;
        this._saveConnectingStateToSession(request, runningBlockingkMode ? -1 : runningCredentialProviderIndex, runningBlockingkMode);
        if (this._doProcess(request, runningBlockingkMode, runningCredentialProvider, redirector, userPopulations)) {
            return true;
        }
        if (existingSession) {
            request.getSession().invalidate();
        }
        return false;
    }

    protected boolean _doProcess(Request request, boolean runningBlockingkMode, CredentialProvider runningCredentialProvider, Redirector redirector, List<UserPopulation> userPopulations) throws Exception {
        if (runningCredentialProvider.grantAnonymousRequest(runningBlockingkMode)) {
            request.setAttribute(REQUEST_ATTRIBUTE_GRANTED, (Object)true);
            return true;
        }
        UserIdentity potentialUserIdentity = null;
        try {
            potentialUserIdentity = runningCredentialProvider.getUserIdentity(runningBlockingkMode, redirector);
        }
        catch (WeakPasswordException e) {
            potentialUserIdentity = e.getUserIdentity();
            this._handleWeakPassword(request, runningCredentialProvider, redirector, potentialUserIdentity);
        }
        if (redirector.hasRedirected()) {
            return true;
        }
        if (potentialUserIdentity == null) {
            return false;
        }
        UserIdentity userIdentity = this._getUserIdentity(userPopulations, potentialUserIdentity, redirector, runningBlockingkMode, runningCredentialProvider);
        if (redirector.hasRedirected()) {
            return true;
        }
        if (userIdentity == null) {
            return false;
        }
        this._setUserIdentityInSession(request, userIdentity, runningCredentialProvider, runningBlockingkMode);
        runningCredentialProvider.userAllowed(runningBlockingkMode, userIdentity, redirector);
        this._userStatusManager.updateConnectionDate(userIdentity);
        this._logLoginEvent(runningCredentialProvider, userIdentity);
        return true;
    }

    protected void _handleWeakPassword(Request request, CredentialProvider runningCredentialProvider, Redirector redirector, UserIdentity userIdentity) throws Exception {
        ForensicLogger.info("authentication.form.weak.password", Map.of("userIdentity", userIdentity), userIdentity);
        Optional<String> resetPasswordURI = this._getWeakPasswordURI(request, userIdentity);
        if (resetPasswordURI.isPresent()) {
            this.getLogger().info("Password of user " + String.valueOf(userIdentity) + " does not meet the security requirements. Force to change password.");
            redirector.redirect(false, resetPasswordURI.get());
            return;
        }
        this.getLogger().warn("Password of user " + String.valueOf(userIdentity) + " does not meet the security requirements. User is authenticated despite the risk for security.");
    }

    protected Optional<String> _getWeakPasswordURI(Request request, UserIdentity userIdentity) {
        if (this._userPasswordManager != null && RuntimeServlet.getRunMode() == RuntimeServlet.RunMode.NORMAL) {
            return this._userPasswordManager.getChangePasswordURI(request, userIdentity, true);
        }
        return Optional.empty();
    }

    protected void _logLoginEvent(CredentialProvider credentialProvider, UserIdentity userIdentity) {
        Map<String, Object> loginArgs = Map.of("credential-provider", credentialProvider.getCredentialProviderModelId(), "user", userIdentity);
        ForensicLogger.info("authentication.login", loginArgs, userIdentity);
    }

    protected void _logLogoutEvent(UserIdentity userIdentity) {
        Map<String, Object> logoutArgs = Map.of("user", userIdentity);
        ForensicLogger.info("authentication.logout", logoutArgs, userIdentity);
    }

    protected static void _resetConnectingStateToSession(Request request) {
        Session session = request.getSession(false);
        if (session != null) {
            session.removeAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX);
            session.removeAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_MODE);
            session.removeAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX_LASTBLOCKINGKNOWN);
            session.removeAttribute(SESSION_CONNECTING_USERPOPULATION_ID);
        }
    }

    protected void _saveConnectingStateToSession(Request request, int runningCredentialProviderIndex, boolean runningBlockingkMode) {
        Session session = request.getSession(true);
        session.setAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX, (Object)runningCredentialProviderIndex);
        session.setAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_MODE, (Object)runningBlockingkMode);
        session.setAttribute(SESSION_CONNECTING_USERPOPULATION_ID, request.getAttribute(REQUEST_ATTRIBUTE_USER_POPULATION_ID));
    }

    protected void _setUserIdentityInSession(Request request, UserIdentity userIdentity, CredentialProvider credentialProvider, boolean blockingMode) {
        AuthenticateAction.setUserIdentityInSession(request, userIdentity, credentialProvider, blockingMode);
        if (this._observationManager != null) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("user", userIdentity);
            this._observationManager.notify(new Event("user.loggedin", UserPopulationDAO.SYSTEM_USER_IDENTITY, eventParams));
        }
    }

    public static void setUserIdentityInSession(Request request, UserIdentity userIdentity, CredentialProvider credentialProvider, boolean blockingMode) {
        Session session = AuthenticateAction.renewSession(request);
        AuthenticateAction._resetConnectingStateToSession(request);
        session.setAttribute(SESSION_USERIDENTITY, (Object)userIdentity);
        session.setAttribute(SESSION_CREDENTIALPROVIDER, (Object)credentialProvider);
        session.setAttribute(SESSION_CREDENTIALPROVIDER_MODE, (Object)blockingMode);
    }

    public static Session renewSession(Request request) {
        Session session = request.getSession(true);
        HashMap<String, Object> attributesCopy = new HashMap<String, Object>();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            attributesCopy.put(attributeName, session.getAttribute(attributeName));
        }
        session.invalidate();
        session = request.getSession(true);
        for (Map.Entry attribute : attributesCopy.entrySet()) {
            session.setAttribute((String)attribute.getKey(), attribute.getValue());
        }
        return session;
    }

    protected UserIdentity _getUserIdentityFromSession(Request request) {
        return AuthenticateAction.getUserIdentityFromSession(request);
    }

    public static UserIdentity getUserIdentityFromSession(Request request) {
        Session session = request.getSession(false);
        if (session != null) {
            return (UserIdentity)session.getAttribute(SESSION_USERIDENTITY);
        }
        return null;
    }

    protected CredentialProvider _getCredentialProviderFromSession(Request request) {
        return AuthenticateAction.getCredentialProviderFromSession(request);
    }

    public static CredentialProvider getCredentialProviderFromSession(Request request) {
        Session session = request.getSession(false);
        if (session != null) {
            return (CredentialProvider)session.getAttribute(SESSION_CREDENTIALPROVIDER);
        }
        return null;
    }

    protected Boolean _getCredentialProviderModeFromSession(Request request) {
        return AuthenticateAction.getCredentialProviderModeFromSession(request);
    }

    public static Boolean getCredentialProviderModeFromSession(Request request) {
        Session session = request.getSession(false);
        if (session != null) {
            return (Boolean)session.getAttribute(SESSION_CREDENTIALPROVIDER_MODE);
        }
        return null;
    }

    protected boolean _isCurrentCredentialProviderInBlockingMode(Request request) {
        if (Strings.CS.equals(request.getParameter(REQUEST_PARAMETER_NONBLOCING), "force")) {
            return false;
        }
        Integer requestedCredentialParameterIndex = this._getCurrentCredentialProviderIndexFromParameter(request);
        if (requestedCredentialParameterIndex != null && requestedCredentialParameterIndex != -1) {
            return true;
        }
        Session session = request.getSession(false);
        if (session != null) {
            Boolean mode = (Boolean)session.getAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_MODE);
            session.removeAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_MODE);
            if (mode != null) {
                return mode;
            }
        }
        return false;
    }

    public static void skipCurrentCredentialProvider(Request request) {
        Integer cpIndex;
        Session session = request.getSession();
        if (session != null && (cpIndex = (Integer)session.getAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX)) != null) {
            Integer n = cpIndex;
            cpIndex = cpIndex + 1;
            session.setAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX, (Object)cpIndex);
        }
    }

    protected Integer _getCurrentCredentialProviderIndexFromParameter(Request request) {
        String requestedCredentialParameterIndex = request.getParameter(REQUEST_PARAMETER_CREDENTIALPROVIDER_INDEX);
        if (StringUtils.isNotBlank((CharSequence)requestedCredentialParameterIndex)) {
            int index = Integer.parseInt(requestedCredentialParameterIndex);
            return index;
        }
        return null;
    }

    protected int _getCurrentCredentialProviderIndex(Request request, List<CredentialProvider> availableCredentialProviders) {
        Integer requestedCredentialParameterIndex = this._getCurrentCredentialProviderIndexFromParameter(request);
        if (requestedCredentialParameterIndex != null) {
            if (requestedCredentialParameterIndex < availableCredentialProviders.size()) {
                return requestedCredentialParameterIndex;
            }
            return -1;
        }
        Session session = request.getSession(false);
        if (session != null) {
            Integer cpIndex = (Integer)session.getAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX);
            session.removeAttribute(SESSION_CONNECTING_CREDENTIALPROVIDER_INDEX);
            if (cpIndex != null) {
                return cpIndex;
            }
        }
        return -1;
    }

    protected List<String> _getContexts(Request request, Parameters parameters) {
        String context = parameters.getParameter("context", null);
        if (context == null) {
            throw new IllegalArgumentException("The authentication is not parameterized correctly: an authentication context must be specified");
        }
        return Collections.singletonList(context);
    }

    protected boolean _internalRequest(Request request) {
        return "true".equals(request.getAttribute(REQUEST_ATTRIBUTE_AUTHENTICATED)) || request.getAttribute(REQUEST_ATTRIBUTE_INTERNAL_ALLOWED) != null;
    }

    protected boolean _acceptedUrl(Request request) {
        String url = (String)request.getAttribute("inWorkspaceURL");
        for (Pattern pattern : this._acceptedUrlPatterns) {
            if (!pattern.matcher(url).matches()) continue;
            request.setAttribute(REQUEST_ATTRIBUTE_GRANTED, (Object)true);
            return true;
        }
        return false;
    }

    protected boolean _validateCurrentlyConnectedUser(Request request, Redirector redirector, Parameters parameters) throws Exception {
        Session session = request.getSession(false);
        UserIdentity userCurrentlyConnected = this._getUserIdentityFromSession(request);
        CredentialProvider runningCredentialProvider = this._getCredentialProviderFromSession(request);
        Boolean runningBlockingkMode = this._getCredentialProviderModeFromSession(request);
        if (runningCredentialProvider == null || userCurrentlyConnected == null || runningBlockingkMode == null || !runningCredentialProvider.isStillConnected(runningBlockingkMode, userCurrentlyConnected, redirector)) {
            if (redirector.hasRedirected()) {
                return true;
            }
            if (session != null && userCurrentlyConnected != null) {
                session.invalidate();
            }
            return false;
        }
        if (RuntimeServlet.getRunMode() == RuntimeServlet.RunMode.MAINTENANCE && MaintenanceAction.acceptedUrl(request)) {
            return true;
        }
        this._validateCurrentlyConnectedUserIsInAuthorizedPopulation(userCurrentlyConnected, request, parameters);
        return true;
    }

    protected void _validateCurrentlyConnectedUserIsInAuthorizedPopulation(UserIdentity userCurrentlyConnected, Request request, Parameters parameters) {
        if (this._getTokenMode(parameters) == TOKEN_MODE.DEFAULT) {
            List<String> contexts = this._getContexts(request, parameters);
            Set<String> availableUserPopulationsIds = this._getAvailableUserPopulationsIds(request, contexts);
            if (!availableUserPopulationsIds.contains(userCurrentlyConnected.getPopulationId())) {
                throw new AccessDeniedException("The user " + String.valueOf(userCurrentlyConnected) + " cannot be authenticated to the contexts '" + StringUtils.join(contexts, (String)"', '") + "' because its populations are not part of the " + availableUserPopulationsIds.size() + " granted populations.");
            }
        } else {
            List availableUserPopulationsIds = this._userPopulationDAO.getEnabledUserPopulations(false).stream().map(UserPopulation::getId).collect(Collectors.toList());
            if (!availableUserPopulationsIds.contains(userCurrentlyConnected.getPopulationId())) {
                throw new AccessDeniedException("The user " + String.valueOf(userCurrentlyConnected) + " cannot be authenticated because its populations does not exist or it is disabled.");
            }
        }
    }

    protected boolean _handleLogout(Redirector redirector, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (Strings.CS.equals(request.getContextPath() + String.valueOf(request.getAttribute("workspaceURI")) + "/logout.html", request.getRequestURI()) || Strings.CS.equals("true", parameters.getParameter("logout", "false"))) {
            UserIdentity currentUser = this._currentUserProvider.getUser();
            if (currentUser != null) {
                this._currentUserProvider.logout(redirector);
                this._logLogoutEvent(currentUser);
            }
            if (!redirector.hasRedirected()) {
                redirector.redirect(false, this.getLogoutURL(request));
            }
            return true;
        }
        return false;
    }

    protected UserIdentity _getUserIdentity(List<UserPopulation> userPopulations, UserIdentity potentialUserIdentity, Redirector redirector, boolean runningBlockingkMode, CredentialProvider runningCredentialProvider) throws Exception {
        if (potentialUserIdentity.getPopulationId() == null) {
            for (UserPopulation up : userPopulations) {
                User user = this._userManager.getUser(up, potentialUserIdentity.getLogin());
                if (!this._isLoginCaseExact(user, potentialUserIdentity)) continue;
                return user.getIdentity();
            }
        } else {
            User user = this._userManager.getUser(potentialUserIdentity.getPopulationId(), potentialUserIdentity.getLogin());
            if (this._isLoginCaseExact(user, potentialUserIdentity)) {
                return user.getIdentity();
            }
        }
        runningCredentialProvider.userNotAllowed(runningBlockingkMode, redirector);
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("The user '" + String.valueOf(potentialUserIdentity) + "' was authenticated by the credential provider '" + runningCredentialProvider.getCredentialProviderModelId() + "' but it does not match any user of the " + userPopulations.size() + " granted populations.");
        }
        return null;
    }

    private boolean _isLoginCaseExact(User user, UserIdentity potentialUserIdentity) {
        return user != null && (user.getUserDirectory().isCaseSensitive() && Strings.CS.equals(user.getIdentity().getLogin(), potentialUserIdentity.getLogin()) || !user.getUserDirectory().isCaseSensitive() && Strings.CI.equals(user.getIdentity().getLogin(), potentialUserIdentity.getLogin()));
    }

    protected static enum TOKEN_MODE {
        TOKEN_ONLY,
        ALLOW_ANONYMOUS,
        DEFAULT;

    }
}

