/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.authentication;

import java.util.Map;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.NonBlockingCredentialProvider;
import org.ametys.core.user.UserIdentity;
import org.apache.cocoon.environment.Redirector;

public interface CredentialProvider {
    public String getId();

    public String getLabel();

    public String getCredentialProviderModelId();

    public Map<String, Object> getParameterValues();

    public void init(String var1, String var2, Map<String, Object> var3, String var4) throws Exception;

    default public boolean grantAnonymousRequest(boolean blockingkMode) {
        if (!blockingkMode && this instanceof NonBlockingCredentialProvider) {
            return ((NonBlockingCredentialProvider)this).nonBlockingGrantAnonymousRequest();
        }
        if (blockingkMode && this instanceof BlockingCredentialProvider) {
            return ((BlockingCredentialProvider)this).blockingGrantAnonymousRequest();
        }
        return false;
    }

    default public boolean isStillConnected(boolean blockingkMode, UserIdentity userCurrentlyConnected, Redirector redirector) throws Exception {
        if (!blockingkMode && this instanceof NonBlockingCredentialProvider) {
            return ((NonBlockingCredentialProvider)this).nonBlockingIsStillConnected(userCurrentlyConnected, redirector);
        }
        if (blockingkMode && this instanceof BlockingCredentialProvider) {
            return ((BlockingCredentialProvider)this).blockingIsStillConnected(userCurrentlyConnected, redirector);
        }
        return false;
    }

    default public UserIdentity getUserIdentity(boolean blockingkMode, Redirector redirector) throws Exception {
        if (!blockingkMode && this instanceof NonBlockingCredentialProvider) {
            return ((NonBlockingCredentialProvider)this).nonBlockingGetUserIdentity(redirector);
        }
        if (blockingkMode && this instanceof BlockingCredentialProvider) {
            return ((BlockingCredentialProvider)this).blockingGetUserIdentity(redirector);
        }
        return null;
    }

    default public void userNotAllowed(boolean blockingkMode, Redirector redirector) throws Exception {
        if (!blockingkMode && this instanceof NonBlockingCredentialProvider) {
            ((NonBlockingCredentialProvider)this).nonBlockingUserNotAllowed(redirector);
        } else if (blockingkMode && this instanceof BlockingCredentialProvider) {
            ((BlockingCredentialProvider)this).blockingUserNotAllowed(redirector);
        }
    }

    default public void userAllowed(boolean blockingkMode, UserIdentity userIdentity, Redirector redirector) throws Exception {
        if (!blockingkMode && this instanceof NonBlockingCredentialProvider) {
            ((NonBlockingCredentialProvider)this).nonBlockingUserAllowed(userIdentity, redirector);
        } else if (blockingkMode && this instanceof BlockingCredentialProvider) {
            ((BlockingCredentialProvider)this).blockingUserAllowed(userIdentity, redirector);
        }
    }
}

