/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.authentication.token;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.util.DateUtils;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetAuthenticationTokensAction
extends ServiceableAction {
    private AuthenticationTokenManager _authenticationTokenManager;

    protected AuthenticationTokenManager getAuthenticationTokenManager() {
        if (this._authenticationTokenManager == null) {
            try {
                this._authenticationTokenManager = (AuthenticationTokenManager)this.manager.lookup(AuthenticationTokenManager.ROLE);
            }
            catch (ServiceException e) {
                throw new IllegalStateException("Cannot get " + AuthenticationTokenManager.ROLE, e);
            }
        }
        return this._authenticationTokenManager;
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap result = new HashMap();
        ArrayList tokensList = new ArrayList();
        List<AuthenticationTokenManager.Token> tokens = this.getAuthenticationTokenManager().getTokens("User");
        for (AuthenticationTokenManager.Token token : tokens) {
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("id", token.getId());
            infos.put("description", token.getComment());
            Date creationDate = token.getCreationDate();
            infos.put("creationDate", creationDate != null ? DateUtils.dateToString(creationDate) : null);
            Date endDate = token.getEndDate();
            infos.put("endDate", endDate != null ? DateUtils.dateToString(endDate) : null);
            infos.put("nbUsesLeft", token.getNbUsesLeft());
            infos.put("contexts", token.getContexts());
            infos.put("comment", token.getComment());
            tokensList.add(infos);
        }
        result.put("tokens", tokensList);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

