/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cache;

import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.ametys.core.cache.Cache;
import org.ametys.core.cache.CacheException;
import org.ametys.core.cache.CacheStats;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.core.impl.cache.GuavaCacheStats;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.request.RequestListener;
import org.ametys.runtime.request.RequestListenerManager;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractCacheManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable,
Initializable,
RequestListener {
    public static final String ROLE = AbstractCacheManager.class.getPackageName() + ".CacheManager";
    protected Map<String, Cache> _memoryCaches = new HashMap<String, Cache>();
    protected Map<String, CacheInfo> _requestsCacheInfos = new HashMap<String, CacheInfo>();
    protected Map<String, CacheStats> _requestsCacheStats = new HashMap<String, CacheStats>();
    protected Map<String, List<WeakReference<Cache>>> _requestCaches = new HashMap<String, List<WeakReference<Cache>>>();
    protected Context _context;
    protected RequestListenerManager _requestListenerManager;

    public void initialize() throws Exception {
        this._requestListenerManager.registerListener(this);
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._requestListenerManager = (RequestListenerManager)serviceManager.lookup(RequestListenerManager.ROLE);
    }

    @Override
    public void requestEnded(HttpServletRequest req) {
        this._requestsCacheInfos.keySet().forEach(id -> {
            Cache requestCache;
            Cache cache = requestCache = req != null ? (Cache)req.getAttribute(ROLE + "$" + id) : null;
            if (requestCache != null) {
                requestCache.getId();
                CacheStats cacheStats = requestCache.getCacheStats();
                CacheStats totalCacheStats = this._requestsCacheStats.get(id);
                totalCacheStats = totalCacheStats.plus(cacheStats);
                this._requestsCacheStats.put((String)id, totalCacheStats);
            }
        });
    }

    public void refreshStats(Request req, String id) {
        Cache requestCache;
        Cache cache = requestCache = req != null ? (Cache)req.getAttribute(ROLE + "$" + id) : null;
        if (requestCache != null) {
            requestCache.getId();
            CacheStats cacheStats = requestCache.getCacheStats();
            CacheStats totalCacheStats = this._requestsCacheStats.get(id);
            totalCacheStats = totalCacheStats.plus(cacheStats);
            this._requestsCacheStats.put(id, totalCacheStats);
        }
    }

    @Override
    public void requestStarted(HttpServletRequest req) {
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void createMemoryCache(String id, I18nizableText name, I18nizableText description, boolean computableSize, Duration duration) throws CacheException {
        this._createCache(id, name, description, CacheType.MEMORY, computableSize, duration, false);
    }

    public void createRequestCache(String id, I18nizableText name, I18nizableText description, boolean isDispatchable) throws CacheException {
        this._createCache(id, name, description, CacheType.REQUEST, false, null, isDispatchable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _createCache(String id, I18nizableText name, I18nizableText description, CacheType cacheType, boolean computableSize, Duration duration, boolean isDispatchable) throws CacheException {
        if (this._memoryCaches.containsKey(id) || this._requestsCacheInfos.containsKey(id)) {
            throw new CacheException("The cache '" + id + "' already exists");
        }
        if (cacheType == CacheType.MEMORY) {
            Cache ametysCache = this._createCache(id, name, description, computableSize, duration, false);
            this._memoryCaches.put(id, ametysCache);
        } else {
            this._requestsCacheInfos.put(id, new CacheInfo(name, description, isDispatchable));
            this._requestsCacheStats.put(id, new GuavaCacheStats());
            Map<String, List<WeakReference<Cache>>> map = this._requestCaches;
            synchronized (map) {
                this._requestCaches.put(id, new ArrayList());
            }
        }
    }

    public synchronized void removeCache(String id, CacheType cacheType) throws CacheException {
        switch (cacheType.ordinal()) {
            case 1: {
                if (!this._memoryCaches.containsKey(id)) break;
                this._memoryCaches.remove(id);
                return;
            }
            case 0: {
                if (!this._requestsCacheInfos.containsKey(id)) break;
                this._requestsCacheInfos.remove(id);
                this._requestCaches.remove(id);
                this._requestsCacheStats.remove(id);
                return;
            }
            default: {
                throw new IllegalStateException("Unknown CacheType " + String.valueOf((Object)cacheType));
            }
        }
        throw new CacheException("The cache '" + id + "' does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> get(String id) throws CacheException {
        Cache<K, V> requestCache;
        if (!this._memoryCaches.containsKey(id) && !this._requestsCacheInfos.containsKey(id)) {
            throw new CacheException("Cache " + id + " does not exist ");
        }
        if (this._memoryCaches.containsKey(id)) {
            return this._memoryCaches.get(id);
        }
        Request request = null;
        try {
            request = ContextHelper.getRequest((Context)this._context);
        }
        catch (CascadingRuntimeException e) {
            this.getLogger().debug("No request available when getting cache {}", (Object)id, (Object)e);
        }
        Cache<K, V> cache = requestCache = request != null ? (Cache<K, V>)request.getAttribute(ROLE + "$" + id) : null;
        if (requestCache == null) {
            CacheInfo cacheInfo = this._requestsCacheInfos.get(id);
            requestCache = this._createCache(id, cacheInfo.getName(), cacheInfo.getDescription(), false, null, cacheInfo.isDispatchable());
            Map<String, List<WeakReference<Cache>>> map = this._requestCaches;
            synchronized (map) {
                this._requestCaches.get(id).add(new WeakReference<Cache<K, V>>(requestCache));
            }
            if (request != null) {
                request.setAttribute(ROLE + "$" + id, requestCache);
            }
        }
        return requestCache;
    }

    public List<Cache> getAllMemoryCaches() {
        return new ArrayList<Cache>(this._memoryCaches.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Pair<String, CacheType>, List<Cache>> getAllCaches() {
        HashMap<Pair<String, CacheType>, List<Cache>> caches = new HashMap<Pair<String, CacheType>, List<Cache>>();
        this._memoryCaches.forEach((id, cache) -> caches.put(Pair.of((Object)id, (Object)((Object)CacheType.MEMORY)), Collections.singletonList(cache)));
        Map<String, List<WeakReference<Cache>>> map = this._requestCaches;
        synchronized (map) {
            this._requestCaches.forEach((id, cacheList) -> this._requestCaches.put((String)id, cacheList.stream().filter(wr -> wr.get() != null).collect(Collectors.toList())));
            this._requestCaches.forEach((id, cacheList) -> caches.put(Pair.of((Object)id, (Object)((Object)CacheType.REQUEST)), cacheList.stream().map(wr -> (Cache)wr.get()).collect(Collectors.toList())));
        }
        return caches;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getCachesAsJSONMap() {
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>();
        this._memoryCaches.forEach((k, v) -> properties.add(v.toJSONMap(this.getLogger())));
        this._requestsCacheStats.forEach((k, v) -> properties.add(this.toJSONMap((String)k, this._requestsCacheInfos.get(k), (CacheStats)v)));
        return properties;
    }

    public boolean hasCache(String id) {
        return this._memoryCaches.containsKey(id) || this._requestsCacheInfos.containsKey(id);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public boolean setSize(String id, long size) throws CacheException, UnsupportedOperationException {
        throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
    }

    protected abstract <K, V> Cache<K, V> _createCache(String var1, I18nizableText var2, I18nizableText var3, boolean var4, Duration var5, boolean var6);

    private Map<String, Object> toJSONMap(String id, CacheInfo cacheInfo, CacheStats cacheStats) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", id);
        properties.put("label", cacheInfo.getName());
        properties.put("description", cacheInfo.getDescription());
        properties.put("computableSize", false);
        properties.put("access", cacheStats.requestCount());
        properties.put("hit", cacheStats.hitCount());
        properties.put("hitRate", cacheStats.hitRate());
        properties.put("miss", cacheStats.missCount());
        properties.put("missRate", cacheStats.missRate());
        properties.put("nbEviction", cacheStats.evictionCount());
        properties.put("type", (Object)CacheType.REQUEST);
        properties.put("currentSize", 0);
        properties.put("maxSize", 0);
        return properties;
    }

    public List<String> resetAllMemoryCaches() {
        ArrayList<String> cleanedCacheIds = new ArrayList<String>();
        for (Cache cache : this.getAllMemoryCaches()) {
            cache.resetCache();
            cleanedCacheIds.add(cache.getId());
        }
        return cleanedCacheIds;
    }

    public List<String> resetCaches(List<String> ids) {
        ArrayList<String> cleanedCacheIds = new ArrayList<String>();
        for (String id : ids) {
            try {
                this.get(id).resetCache();
                cleanedCacheIds.add(id);
            }
            catch (CacheException e) {
                this.getLogger().warn("Failed to clear cache with id '{}'. No cache exists with this id.", (Object)id, (Object)e);
            }
        }
        return cleanedCacheIds;
    }

    public void resetAllNonDispatchableRequestCaches() {
        Request request = null;
        try {
            request = ContextHelper.getRequest((Context)this._context);
        }
        catch (CascadingRuntimeException e) {
            this.getLogger().debug("No request available when resetting non dispatchable request caches", (Throwable)e);
            return;
        }
        ArrayList<String> attrNames = Collections.list(request.getAttributeNames());
        for (String attrName : attrNames) {
            String id;
            Cache cache;
            if (attrName == null || !attrName.startsWith(ROLE) || (cache = this.get(id = Strings.CS.replace(attrName, ROLE + "$", ""))).isDispatchable()) continue;
            this.refreshStats(request, id);
            cache.resetCache();
        }
    }

    public static enum CacheType {
        REQUEST,
        MEMORY;

    }

    protected static final class CacheInfo {
        private I18nizableText _name;
        private I18nizableText _description;
        private boolean _isDispatchable;

        public CacheInfo(I18nizableText name, I18nizableText description, boolean isDispatchable) {
            this._name = name;
            this._description = description;
            this._isDispatchable = isDispatchable;
        }

        public I18nizableText getName() {
            return this._name;
        }

        public I18nizableText getDescription() {
            return this._description;
        }

        public boolean isDispatchable() {
            return this._isDispatchable;
        }
    }
}

