/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.CacheException;
import org.ametys.core.cache.CacheStats;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.runtime.i18n.I18nizableText;
import org.slf4j.Logger;

public interface Cache<K, V> {
    public V get(K var1, Function<K, V> var2) throws CacheException;

    public V get(K var1);

    public Map<K, V> getAll(AbstractCacheKey var1);

    public void put(K var1, V var2);

    public void putAll(Map<K, V> var1);

    public boolean hasKey(K var1);

    public void invalidate(K var1);

    public void invalidateAll();

    public void resetCache();

    public CacheStats getCacheStats();

    public long getMemorySize() throws CacheException;

    public long getMaxSize();

    public long getNumberOfElements();

    public I18nizableText getLabel();

    public I18nizableText getDescription();

    public String getId();

    public boolean isComputableSize();

    public Map<K, V> asMap();

    default public Map<String, Object> toJSONMap(Logger logger) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("id", this.getId());
        properties.put("label", this.getLabel());
        properties.put("description", this.getDescription());
        properties.put("computableSize", this.isComputableSize());
        properties.put("access", this.getCacheStats().requestCount());
        properties.put("hit", this.getCacheStats().hitCount());
        properties.put("hitRate", this.getCacheStats().hitRate());
        properties.put("miss", this.getCacheStats().missCount());
        properties.put("missRate", this.getCacheStats().missRate());
        properties.put("nbElement", this.getNumberOfElements());
        properties.put("nbEviction", this.getCacheStats().evictionCount());
        properties.put("type", (Object)AbstractCacheManager.CacheType.MEMORY);
        try {
            properties.put("currentSize", this.getMemorySize());
        }
        catch (CacheException e) {
            logger.error("Unable to compute size of cache: {} - {}", new Object[]{this.getId(), this.getLabel(), e});
            properties.put("currentSize", -1);
        }
        properties.put("maxSize", this.getMaxSize());
        return properties;
    }

    public boolean isInitialized();

    public boolean isDispatchable();
}

