/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cache;

import java.util.Collections;
import java.util.List;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.caching.Cache;

public class CacheClientSideElement
extends StaticClientSideElement {
    private AbstractCacheManager _cacheManager;
    private Cache _cocoonCache;
    private ObservationManager _observationManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cacheManager = (AbstractCacheManager)smanager.lookup(AbstractCacheManager.ROLE);
        this._cocoonCache = (Cache)smanager.lookup(Cache.ROLE);
        if (smanager.hasService(ObservationManager.ROLE)) {
            this._observationManager = (ObservationManager)((Object)smanager.lookup(ObservationManager.ROLE));
        }
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public void clearCaches(List<String> ids) {
        List<String> cleanedCaches = this._cacheManager.resetCaches(ids);
        for (String cacheId : cleanedCaches) {
            if (this._observationManager == null) continue;
            this._observationManager.notify(new Event("cache.reset", this._currentUserProvider.getUser(), Collections.singletonMap("cache.id", cacheId)));
        }
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<String> clearAllCaches() {
        List<String> cleanedCaches = this._cacheManager.resetAllMemoryCaches();
        for (String cacheId : cleanedCaches) {
            if (this._observationManager == null) continue;
            this._observationManager.notify(new Event("cache.reset", this._currentUserProvider.getUser(), Collections.singletonMap("cache.id", cacheId)));
        }
        return cleanedCaches;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public void emptyCocoonCache() {
        this._cocoonCache.clear();
    }
}

