/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cache;

import java.util.Collections;
import java.util.List;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class CleanCacheSchedulable
extends AbstractStaticSchedulable {
    public static final String JOBDATAMAP_CACHE_IDS = "cacheIds";
    public static final String JOBDATAMAP_ALL_CACHES = "allCaches";
    protected AbstractCacheManager _cacheManager;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._observationManager = (ObservationManager)((Object)manager.lookup(ObservationManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String[] cacheIds = (String[])jobDataMap.get((Object)"parameterValues#cacheIds");
        List<String> cleanedCaches = cacheIds.length == 0 ? this._cacheManager.resetAllMemoryCaches() : this._cacheManager.resetCaches(List.of(cacheIds));
        for (String cacheId : cleanedCaches) {
            this._observationManager.notify(new Event("cache.reset", this._currentUserProvider.getUser(), Collections.singletonMap("cache.id", cacheId)));
        }
    }
}

