/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cache;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.cache.CacheException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.tuple.Pair;

public class MemoryCacheEnumerator
implements Enumerator<String>,
Serviceable {
    protected AbstractCacheManager _cacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    @Override
    public I18nizableText getEntry(String value) throws Exception {
        try {
            return Optional.ofNullable(value).map(this._cacheManager::get).map(Cache::getLabel).orElse(null);
        }
        catch (CacheException cacheException) {
            return null;
        }
    }

    @Override
    public Map<String, I18nizableText> getEntries() throws Exception {
        return this._cacheManager.getAllCaches().entrySet().stream().filter(entry -> ((Pair)entry.getKey()).getRight() == AbstractCacheManager.CacheType.MEMORY).map(Map.Entry::getValue).filter(Predicate.not(List::isEmpty)).map(list -> (Cache)list.get(0)).collect(Collectors.toMap(Cache::getId, Cache::getLabel));
    }
}

