/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.captcha;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ametys.core.captcha.Captcha;
import org.ametys.runtime.plugin.Feature;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.source.SourceException;

public abstract class AbstractCaptcha
extends AbstractLogEnabled
implements PluginAware,
Configurable,
Captcha {
    private String _pluginName;
    private String _id;
    private String _xslPath;
    private String _scssPath;
    private String _featureName;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._id = id;
        this._featureName = featureName;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._xslPath = configuration.getChild("xslPath").getValue();
        this._scssPath = configuration.getChild("scssPath").getValue();
    }

    @Override
    public Collection<String> getConfigParameters() {
        Feature feature = PluginsManager.getInstance().getFeatures().get(this._pluginName + "/" + this._featureName);
        Set<String> configParametersDeclared = feature.getConfigParameters().keySet();
        Collection<String> configParametersReferences = feature.getConfigParametersReferences();
        HashSet<String> configParameters = new HashSet<String>();
        configParameters.addAll(configParametersDeclared);
        configParameters.addAll(configParametersReferences);
        return configParameters;
    }

    @Override
    public String getXSLHelperURL() throws SourceException {
        return "plugin:" + this._pluginName + "://" + this._xslPath;
    }

    @Override
    public String getLoginSCSSURL() throws SourceException {
        return "plugin:" + this._pluginName + "://" + this._scssPath;
    }
}

