/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.captcha;

import java.util.Collection;
import java.util.regex.Pattern;
import org.ametys.core.captcha.Captcha;
import org.ametys.core.captcha.CaptchaExtensionPoint;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public final class CaptchaHelper
implements Serviceable,
Initializable,
Disposable {
    public static final String ROLE = CaptchaHelper.class.getName();
    private static final String _CAPTCHA_TYPE_KEY = "runtime.captcha.type";
    private static final String _DEFAULT_CAPTCHA_IMPL = "jcaptcha";
    private static CaptchaExtensionPoint _captchaExtensionPoint;
    private static Captcha _captcha;

    public void initialize() throws Exception {
        _captcha = null;
    }

    public void service(ServiceManager manager) throws ServiceException {
        _captchaExtensionPoint = (CaptchaExtensionPoint)manager.lookup(CaptchaExtensionPoint.ROLE);
    }

    public static String getCaptchaType() {
        if (_captcha != null) {
            return _captcha.getId();
        }
        if (Config.getInstance() != null && _captchaExtensionPoint != null && _captchaExtensionPoint.hasExtension((String)Config.getInstance().getValue(_CAPTCHA_TYPE_KEY))) {
            return (String)Config.getInstance().getValue(_CAPTCHA_TYPE_KEY);
        }
        return _DEFAULT_CAPTCHA_IMPL;
    }

    public static Captcha getCaptcha() {
        if (_captcha != null) {
            return _captcha;
        }
        if (_captchaExtensionPoint != null) {
            String key;
            String string = key = Config.getInstance() != null ? (String)Config.getInstance().getValue(_CAPTCHA_TYPE_KEY) : null;
            if (key == null || !_captchaExtensionPoint.hasExtension(key)) {
                key = _DEFAULT_CAPTCHA_IMPL;
            }
            _captcha = (Captcha)_captchaExtensionPoint.getExtension(key);
            return _captcha;
        }
        throw new IllegalStateException("No captcha implementation found");
    }

    public static boolean checkAndInvalidate(String key, String value) {
        return CaptchaHelper.getCaptcha().checkAndInvalidateCaptcha(key, value);
    }

    public static String getFailedI18NKey() {
        return CaptchaHelper.getCaptcha().getLoginFailedBecauseCaptchaFailedLabel().getKey();
    }

    public static String getFailedI18NCatalog() {
        return CaptchaHelper.getCaptcha().getLoginFailedBecauseCaptchaFailedLabel().getCatalogue();
    }

    public static String getTooManyAttemptI18NKey() {
        return CaptchaHelper.getCaptcha().getLoginFailedBecauseCaptchaFailedLabel().getKey();
    }

    public static String getTooManyAttemptI18NCatalog() {
        return CaptchaHelper.getCaptcha().getLoginFailedBecauseCaptchaFailedLabel().getCatalogue();
    }

    public static Collection<Pattern> getUsedUrlPatterns() {
        return CaptchaHelper.getCaptcha().getUsedUrlPatterns();
    }

    public static boolean requiresUserInteraction() {
        return CaptchaHelper.getCaptcha().requireUserInteraction();
    }

    public void dispose() {
        CaptchaHelper.staticDispose();
    }

    public static void staticDispose() {
        _captcha = null;
    }
}

