/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.captcha;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.captcha.Captcha;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;

public class CaptchaSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable {
    private static final Pattern __SOURCE_PATTERN = Pattern.compile("^[\\w]+://(.*)$");
    private SourceResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public Source getSource(String location, Map parameters) throws IOException {
        Matcher m = __SOURCE_PATTERN.matcher(location);
        if (!m.matches()) {
            throw new MalformedURLException("URI must be like protocol://helper.xsl. Location was '" + location + "'");
        }
        String path = m.group(1);
        if (Strings.CS.equals(path, "helper.xsl")) {
            Captcha captcha = CaptchaHelper.getCaptcha();
            return this._resolver.resolveURI(captcha.getXSLHelperURL());
        }
        if (Strings.CS.equals(path, "login.scss")) {
            Captcha captcha = CaptchaHelper.getCaptcha();
            Source sourceToWrap = this._resolver.resolveURI(captcha.getLoginSCSSURL());
            return new LastModifiedWithConfigSourceProxy(sourceToWrap);
        }
        throw new SourceNotFoundException("The path " + path + " is not suported");
    }

    public void release(Source source) {
    }

    private static class LastModifiedWithConfigSourceProxy
    implements Source {
        private Source _source;

        LastModifiedWithConfigSourceProxy(Source source) {
            this._source = source;
        }

        public boolean exists() {
            return this._source.exists();
        }

        public InputStream getInputStream() throws IOException, SourceNotFoundException {
            return this._source.getInputStream();
        }

        public String getURI() {
            return this._source.getURI();
        }

        public String getScheme() {
            return this._source.getScheme();
        }

        public SourceValidity getValidity() {
            return this._source.getValidity();
        }

        public void refresh() {
            this._source.refresh();
        }

        public String getMimeType() {
            return this._source.getMimeType();
        }

        public long getContentLength() {
            return this._source.getContentLength();
        }

        public long getLastModified() {
            return Math.max(Config.getInstance().getLastModified(), this._source.getLastModified());
        }
    }
}

