/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.util.StringUtils;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CSVTransformer
extends AbstractTransformer {
    private static final String __TAG_CSV = "csv";
    private static final String __TAG_ROW = "row";
    private static final String __TAG_CELL = "cell";
    private static final char __COLUMN_SEPARATOR = ';';
    private static final String __ROW_SEPARATOR = "\n";
    private static final String __DO_NOT_SANITIZE_ATTR = "doNotSanitize";
    private boolean _inRow;
    private boolean _inCell;
    private boolean _doNotSanitize;
    private StringBuilder _cellBuffer;

    private void _init() {
        this._inRow = false;
        this._inCell = false;
        this._doNotSanitize = false;
        this._cellBuffer = new StringBuilder();
    }

    public void startElement(String uri, String localName, String raw, Attributes atts) throws SAXException {
        if (__TAG_CSV.equals(localName)) {
            super.startElement(uri, localName, raw, atts);
            this._init();
        }
        if (__TAG_ROW.equals(localName)) {
            this._inRow = true;
        }
        if (this._inRow && __TAG_CELL.equals(localName)) {
            this._inCell = true;
            this._cellBuffer = new StringBuilder();
            this._doNotSanitize = "true".equals(atts.getValue(__DO_NOT_SANITIZE_ATTR));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._inCell) {
            String text = new String(ch, start, length);
            this._cellBuffer.append(text);
        }
    }

    public void endElement(String uri, String localName, String raw) throws SAXException {
        if (this._inRow && __TAG_ROW.equals(localName)) {
            super.characters(__ROW_SEPARATOR.toCharArray(), 0, 1);
            this._inRow = false;
        }
        if (this._inCell && __TAG_CELL.equals(localName)) {
            Object sanitizedText = this._cellBuffer.isEmpty() ? "" : (this._doNotSanitize ? StringUtils.escapeCsv(this._cellBuffer.toString()) : StringUtils.sanitizeCsv(this._cellBuffer.toString()));
            sanitizedText = (String)sanitizedText + ";";
            super.characters(((String)sanitizedText).toCharArray(), 0, ((String)sanitizedText).length());
            this._inCell = false;
        }
        if (__TAG_CSV.equals(localName)) {
            super.endElement(uri, localName, raw);
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
    }
}

