/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;

public class FOPNGSerializer
extends AbstractSerializer
implements Configurable,
CacheableProcessingComponent,
Serviceable,
ResourceResolver,
Disposable,
Contextualizable {
    protected SourceResolver _resolver;
    protected FopFactory _fopfactory;
    protected Fop _fop;
    protected String _mimetype;
    protected boolean _setContentLength = true;
    protected ServiceManager _manager;
    private Map<String, String> _rendererOptions;
    private Context _context;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._manager = smanager;
        this._resolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
    }

    /*
     * Unable to fully structure code
     */
    public void configure(Configuration conf) throws ConfigurationException {
        this._setContentLength = conf.getChild("set-content-length").getValueAsBoolean(true);
        base = new File(this._context.getRealPath("/"));
        baseURI = base.toURI();
        fopFactoryBuilder = null;
        configUrl = conf.getChild("user-config").getValue("context://WEB-INF/param/fop-user-config.xml");
        if (configUrl != null) {
            configSource = null;
            resolver = null;
            try {
                resolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
                configSource = resolver.resolveURI(configUrl);
                if (configSource.exists()) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Loading configuration from " + configSource.getURI());
                    }
                    is = configSource.getInputStream();
                    try {
                        confParser = new FopConfParser(is, baseURI, (ResourceResolver)this);
                        fopFactoryBuilder = confParser.getFopFactoryBuilder();
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                } else {
                    throw new SourceNotFoundException("There is no configuration file " + configSource.getURI());
                }
                ** if (resolver == null) goto lbl-1000
            }
            catch (SourceNotFoundException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("There is no configuration file " + configUrl, (Throwable)e);
                }
                ** if (resolver == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    resolver.release(configSource);
                    this._manager.release((Object)resolver);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Cannot load configuration from " + configUrl);
                throw new ConfigurationException("Cannot load configuration from " + configUrl, (Throwable)e);
                {
                    catch (Throwable var11_16) {
                        if (resolver != null) {
                            resolver.release(configSource);
                            this._manager.release((Object)resolver);
                        }
                        throw var11_16;
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                resolver.release(configSource);
                this._manager.release((Object)resolver);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        if (fopFactoryBuilder == null) {
            fopFactoryBuilder = new FopFactoryBuilder(baseURI, (ResourceResolver)this);
        }
        this._fopfactory = fopFactoryBuilder.build();
        this._mimetype = conf.getAttribute("mime-type");
        confRenderer = conf.getChild("renderer-config");
        if (confRenderer != null && (parameters = confRenderer.getChildren("parameter")).length > 0) {
            this._rendererOptions = new HashMap<String, String>();
            for (i = 0; i < parameters.length; ++i) {
                name = parameters[i].getAttribute("name");
                value = parameters[i].getAttribute("value");
                this._rendererOptions.put(name, value);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("renderer " + String.valueOf(name) + " = " + String.valueOf(value));
            }
        }
    }

    public void recycle() {
        super.recycle();
        this._fop = null;
    }

    public void dispose() {
        if (this._resolver != null) {
            this._manager.release((Object)this._resolver);
            this._resolver = null;
        }
        this._manager = null;
    }

    public String getMimeType() {
        return this._mimetype;
    }

    public void setOutputStream(OutputStream out) throws IOException {
        FOUserAgent userAgent = this._fopfactory.newFOUserAgent();
        if (this._rendererOptions != null) {
            userAgent.getRendererOptions().putAll(this._rendererOptions);
        }
        userAgent.setAccessibility(true);
        try {
            this._fop = this._fopfactory.newFop(this.getMimeType(), userAgent, out);
            this.setContentHandler(this._fop.getDefaultHandler());
        }
        catch (FOPException e) {
            this.getLogger().error("FOP setup failed", (Throwable)e);
            throw new IOException("Unable to setup fop: " + e.getLocalizedMessage());
        }
    }

    public Serializable getKey() {
        return "1";
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public boolean shouldSetContentLength() {
        return this._setContentLength;
    }

    public Resource getResource(URI uri) throws IOException {
        String href = uri.toString();
        if (href.indexOf(58) != -1) {
            Source source = this._resolver.resolveURI(href);
            return new Resource(source.getMimeType(), source.getInputStream());
        }
        String base = this._context.getRealPath("/");
        if (href.startsWith("/")) {
            href = href.substring(1);
        }
        File source = new File(base, href);
        return new Resource((InputStream)new FileInputStream(source));
    }

    public OutputStream getOutputStream(URI uri) throws IOException {
        throw new UnsupportedOperationException("getOutputStream");
    }

    public static final class ReleaseSourceInputStream
    extends InputStream {
        private InputStream _delegate;
        private Source _source;
        private SourceResolver _sourceResolver;

        ReleaseSourceInputStream(InputStream delegate, Source source, SourceResolver sourceResolver) {
            this._delegate = delegate;
            this._source = source;
            this._sourceResolver = sourceResolver;
        }

        @Override
        public void close() throws IOException {
            this._delegate.close();
            this._sourceResolver.release(this._source);
        }

        @Override
        public int read() throws IOException {
            return this._delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this._delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this._delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this._delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this._delegate.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this._delegate.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this._delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this._delegate.markSupported();
        }
    }
}

