/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.workspace.WorkspaceManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.xml.ParamSaxBuffer;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public class I18nTransformer
extends org.apache.cocoon.transformation.I18nTransformer
implements Contextualizable {
    protected Context _context;
    protected SourceResolver _resolver;
    protected I18nUtils _i18nUtils;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._i18nUtils = (I18nUtils)((Object)smanager.lookup(I18nUtils.ROLE));
    }

    public void configure(Configuration conf) throws ConfigurationException {
        DefaultConfiguration newConf = new DefaultConfiguration("i18n");
        newConf.addChild(conf.getChild("untranslated-text"));
        newConf.addChild(conf.getChild("cache-at-startup"));
        Configuration cataloguesConf = conf.getChild("catalogues", false);
        DefaultConfiguration catalogues = new DefaultConfiguration("catalogues");
        newConf.addChild((Configuration)catalogues);
        if (cataloguesConf != null) {
            catalogues.addAll(cataloguesConf);
        }
        this._configurePlugins(catalogues);
        this._configureWorkspaces(catalogues);
        this._configureParams(catalogues);
        super.configure((Configuration)newConf);
    }

    private void _configureParams(DefaultConfiguration catalogues) {
        for (String name : this._i18nUtils.getParamsFoldersWithI18n()) {
            DefaultConfiguration catalogue = new DefaultConfiguration("catalogue");
            catalogue.setAttribute("id", "param." + name);
            catalogue.setAttribute("name", "messages");
            DefaultConfiguration location = new DefaultConfiguration("location");
            location.setValue(this._i18nUtils.getParamCatalogLocation(name));
            catalogue.addChild((Configuration)location);
            catalogues.addChild((Configuration)catalogue);
        }
    }

    private void _configurePlugins(DefaultConfiguration catalogues) {
        this._addConfigurations(catalogues, "plugin", PluginsManager.getInstance().getPluginNames());
    }

    private void _configureWorkspaces(DefaultConfiguration catalogues) {
        this._addConfigurations(catalogues, "workspace", WorkspaceManager.getInstance().getWorkspaceNames());
    }

    private void _addConfigurations(DefaultConfiguration catalogues, String type, Set<String> names) {
        for (String name : names) {
            DefaultConfiguration catalogue = new DefaultConfiguration("catalogue");
            catalogue.setAttribute("id", type + "." + name);
            catalogue.setAttribute("name", "messages");
            DefaultConfiguration location1 = new DefaultConfiguration("location");
            location1.setValue(this._i18nUtils.getOverridableCatalogLocation(type, name));
            catalogue.addChild((Configuration)location1);
            DefaultConfiguration location2 = new DefaultConfiguration("location");
            location2.setValue(this._i18nUtils.getDefaultCatalogLocation(type, name));
            catalogue.addChild((Configuration)location2);
            catalogues.addChild((Configuration)catalogue);
        }
    }

    public void setup(org.apache.cocoon.environment.SourceResolver resolver, Map objModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        Parameters newParam = new Parameters();
        String[] names = parameters.getNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if ("plugin".equals(name) || "workspace".equals(name) || "default-catalogue-id".equals(name)) continue;
            String value = parameters.getParameter(name, null);
            newParam.setParameter(name, value);
        }
        String defaultCatalogueId = parameters.getParameter("default-catalogue-id", null);
        String pluginName = parameters.getParameter("plugin", null);
        String workspaceName = parameters.getParameter("workspace", null);
        boolean useDefault = true;
        if (pluginName != null) {
            if (PluginsManager.getInstance().getPluginNames().contains(pluginName)) {
                newParam.setParameter("default-catalogue-id", "plugin." + pluginName);
                useDefault = false;
            }
        } else if (workspaceName != null && WorkspaceManager.getInstance().getWorkspaceNames().contains(workspaceName)) {
            newParam.setParameter("default-catalogue-id", "workspace." + workspaceName);
            useDefault = false;
        }
        if (useDefault) {
            newParam.setParameter("default-catalogue-id", defaultCatalogueId);
        }
        super.setup(resolver, objModel, source, newParam);
    }

    protected ParamSaxBuffer getMessage(String catalogueID, String key) {
        ParamSaxBuffer message = super.getMessage(catalogueID, key);
        if (message == null) {
            return this.getUntranslatedMessage(catalogueID, key);
        }
        return message;
    }

    protected ParamSaxBuffer getUntranslatedMessage(String catalogueID, String key) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Translation not found for key " + key + " in catalogue " + catalogueID);
        }
        try {
            String value = catalogueID + ":" + key;
            ParamSaxBuffer paramSaxBuffer = new ParamSaxBuffer();
            paramSaxBuffer.characters(value.toCharArray(), 0, value.length());
            return paramSaxBuffer;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

