/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.ametys.core.cocoon.XHTMLSerializerExtensionPoint;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XHTMLSerializer
extends org.apache.cocoon.components.serializers.XHTMLSerializer
implements LogEnabled,
Serviceable {
    private static final Set<String> __NAMESPACES_ALLOWED = new HashSet<String>(Arrays.asList("", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/1999/xhtml", "http://www.w3.org/2000/svg", "http://www.w3.org/1998/Math/MathML"));
    private static final Set<String> __COLLAPSE_TAGS = new HashSet<String>(Arrays.asList("input", "img", "meta", "link", "hr", "br"));
    private static final String __HEAD_TAG = "head";
    private static final String __META_TAG = "meta";
    private static final String __META_HTTP_EQUIV_ATTR = "http-equiv";
    private static final String __META_HTTP_EQUIV_CTYPE_VALUE = "Content-Type";
    private static final String __META_CONTENT_ATTR = "content";
    private static final String __SCRIPT_TAG = "script";
    private static final String __STYLE_TAG = "style";
    protected XHTMLSerializerExtensionPoint _xhtmlSerializerExtensionPoint;
    private StringBuilder _buffer;
    private Set<String> _tagsToCollapse;
    private Set<String> _namespacesAllowed;
    private Set<String> _namespacesPrefixFiltered;
    private int _insideFilteredTag;
    private int _insideInlineResourceTag;
    private int _tagsInsideInlineResourceTag;
    private boolean _disableOutputEscaping;
    private boolean _omitXmlDeclaration;
    private boolean _isMetaContentType;
    private Logger _logger;

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        if (manager.hasService(XHTMLSerializerExtensionPoint.ROLE)) {
            this._xhtmlSerializerExtensionPoint = (XHTMLSerializerExtensionPoint)manager.lookup(XHTMLSerializerExtensionPoint.ROLE);
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration[] namespacesAllowed;
        super.configure(conf);
        String omitXmlDeclaration = conf.getChild("omit-xml-declaration").getValue(null);
        this._omitXmlDeclaration = !"no".equals(omitXmlDeclaration);
        String tagsToCollapse = conf.getChild("tags-to-collapse").getValue(null);
        if (tagsToCollapse != null) {
            this._tagsToCollapse = new HashSet<String>();
            for (String tag : tagsToCollapse.split(",")) {
                this._tagsToCollapse.add(tag.trim());
            }
        } else {
            this._tagsToCollapse = __COLLAPSE_TAGS;
        }
        if ((namespacesAllowed = conf.getChildren("namespace-allowed")).length > 0) {
            this._namespacesAllowed = new HashSet<String>();
            for (Configuration namespaceAllowed : namespacesAllowed) {
                String namespace = namespaceAllowed.getValue("");
                this._namespacesAllowed.add(namespace.trim());
            }
        } else {
            this._namespacesAllowed = this._xhtmlSerializerExtensionPoint != null ? this._xhtmlSerializerExtensionPoint.getAllowedNamespaces() : __NAMESPACES_ALLOWED;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._namespacesAllowed.contains(uri)) {
            super.startPrefixMapping(prefix, uri);
        } else {
            this._namespacesPrefixFiltered.add(prefix);
        }
    }

    public void startElement(String nsuri, String local, String qual, Attributes attributes) throws SAXException {
        if (this._insideInlineResourceTag > 0) {
            if (this._logger.isWarnEnabled()) {
                this._logger.warn("Tags are forbidden inside a <script> or <style> tag : <" + local + ">");
            }
            ++this._tagsInsideInlineResourceTag;
        } else if (this._namespacesAllowed.contains(nsuri)) {
            if (this._insideFilteredTag == 0) {
                super.startElement(nsuri, local, qual, this._filterAttributes(attributes));
            }
        } else {
            ++this._insideFilteredTag;
        }
    }

    private Attributes _filterAttributes(Attributes attributes) {
        AttributesImpl attributesFiltered = new AttributesImpl();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qName;
            String uri = attributes.getURI(i);
            if (!this._namespacesAllowed.contains(uri) || (qName = attributes.getQName(i)).equals("xmlns") || qName.startsWith("xmlns:")) continue;
            attributesFiltered.addAttribute(uri, attributes.getLocalName(i), qName, attributes.getType(i), attributes.getValue(i));
        }
        return attributesFiltered;
    }

    public void startElementImpl(String uri, String local, String qual, String[][] lNamespaces, String[][] attributes) throws SAXException {
        if (local.equalsIgnoreCase(__SCRIPT_TAG) && this.isJsScript(local, attributes) || local.equalsIgnoreCase(__STYLE_TAG)) {
            ++this._insideInlineResourceTag;
        }
        this._isMetaContentType = this.isMetaContentType(local, attributes);
        if (!this._isMetaContentType) {
            super.startElementImpl(uri, local, qual, lNamespaces, attributes);
        }
        if (this._omitXmlDeclaration && local.equalsIgnoreCase(__HEAD_TAG)) {
            String qua = this.namespaces.qualify("http://www.w3.org/1999/xhtml", __META_TAG, __META_TAG);
            String[][] attrs = new String[2][4];
            attrs[0][0] = "";
            attrs[0][1] = __META_HTTP_EQUIV_ATTR;
            attrs[0][2] = __META_HTTP_EQUIV_ATTR;
            attrs[0][3] = __META_HTTP_EQUIV_CTYPE_VALUE;
            attrs[1][0] = "";
            attrs[1][1] = __META_CONTENT_ATTR;
            attrs[1][2] = __META_CONTENT_ATTR;
            attrs[1][3] = this.getMimeType();
            super.startElementImpl("http://www.w3.org/1999/xhtml", __META_TAG, qua, new String[0][0], attrs);
            super.endElementImpl("http://www.w3.org/1999/xhtml", __META_TAG, qua);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this._insideFilteredTag == 0) {
            if (this._disableOutputEscaping) {
                this.closeElement(false);
                this.write(ch, start, length);
            } else {
                super.characters(ch, start, length);
            }
        }
    }

    public void charactersImpl(char[] data, int start, int length) throws SAXException {
        if (this._insideInlineResourceTag > 0) {
            this._buffer.append(data, start, length);
        } else {
            super.charactersImpl(data, start, length);
        }
    }

    public void ignorableWhitespace(char[] data, int start, int length) throws SAXException {
        if (this._insideFilteredTag == 0) {
            super.ignorableWhitespace(data, start, length);
        }
    }

    public void comment(char[] data, int start, int length) throws SAXException {
        if (this._insideFilteredTag == 0) {
            if (this._insideInlineResourceTag > 0) {
                this._buffer.append(data, start, length);
            } else {
                super.comment(data, start, length);
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this._insideFilteredTag == 0) {
            if ("javax.xml.transform.disable-output-escaping".equals(target)) {
                this._disableOutputEscaping = true;
            } else if ("javax.xml.transform.enable-output-escaping".equals(target)) {
                this._disableOutputEscaping = false;
            } else {
                super.processingInstruction(target, data);
            }
        }
    }

    public void endElement(String nsuri, String local, String qual) throws SAXException {
        if (this._tagsInsideInlineResourceTag > 0) {
            --this._tagsInsideInlineResourceTag;
        } else if (this._namespacesAllowed.contains(nsuri)) {
            if (this._insideFilteredTag == 0) {
                super.endElement(nsuri, local, qual);
            }
        } else {
            --this._insideFilteredTag;
        }
    }

    public void endElementImpl(String uri, String local, String qual) throws SAXException {
        String namespaceUri = uri;
        if (uri.length() == 0) {
            namespaceUri = "http://www.w3.org/1999/xhtml";
        }
        if (local.equalsIgnoreCase(__SCRIPT_TAG) && this._insideInlineResourceTag > 0) {
            --this._insideInlineResourceTag;
            if (this._buffer.length() > 0) {
                char[] content = new char[this._buffer.length() + 5];
                content[0] = 10;
                content[content.length - 4] = 10;
                content[content.length - 3] = 47;
                content[content.length - 2] = 47;
                content[content.length - 1] = 32;
                this._buffer.getChars(0, this._buffer.length(), content, 1);
                this._buffer.setLength(0);
                super.comment(content, 0, content.length);
            }
        } else if (local.equalsIgnoreCase(__STYLE_TAG)) {
            --this._insideInlineResourceTag;
            if (this._buffer.length() > 0) {
                char[] content = new char[this._buffer.length() + 2];
                content[0] = 10;
                content[content.length - 1] = 10;
                this._buffer.getChars(0, this._buffer.length(), content, 1);
                this._buffer.setLength(0);
                super.comment(content, 0, content.length);
            }
        }
        if ("http://www.w3.org/1999/xhtml".equals(namespaceUri) && !this._tagsToCollapse.contains(local)) {
            this.closeElement(false);
        }
        if (!this._isMetaContentType) {
            super.endElementImpl(namespaceUri, local, qual);
        } else {
            this._isMetaContentType = false;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this._namespacesPrefixFiltered.contains(prefix)) {
            super.endPrefixMapping(prefix);
        }
    }

    private boolean isMetaContentType(String local, String[][] attributes) {
        if (local.equalsIgnoreCase(__META_TAG)) {
            for (String[] attr : attributes) {
                if (!attr[1].equalsIgnoreCase(__META_HTTP_EQUIV_ATTR) || !attr[3].equalsIgnoreCase(__META_HTTP_EQUIV_CTYPE_VALUE)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isJsScript(String local, String[][] attributes) {
        boolean hasTypeAttr = false;
        if (local.equalsIgnoreCase(__SCRIPT_TAG)) {
            for (String[] attr : attributes) {
                if (!attr[1].equalsIgnoreCase("type")) continue;
                hasTypeAttr = true;
                if (!attr[3].equalsIgnoreCase("text/javascript")) continue;
                return true;
            }
        }
        return !hasTypeAttr;
    }

    public void recycle() {
        super.recycle();
        if (this._buffer == null) {
            this._buffer = new StringBuilder(512);
        } else if (this._buffer.capacity() > 102400) {
            this._buffer = new StringBuilder(512);
        } else {
            this._buffer.setLength(0);
        }
        if (this._namespacesPrefixFiltered == null) {
            this._namespacesPrefixFiltered = new HashSet<String>();
        } else {
            this._namespacesPrefixFiltered.clear();
        }
        this._insideFilteredTag = 0;
        this._insideInlineResourceTag = 0;
        this._disableOutputEscaping = false;
        this._isMetaContentType = false;
    }
}

