/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.cocoon.XMLResourceBundle;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.observation.Observer;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.i18n.Bundle;
import org.apache.commons.lang3.LocaleUtils;

public class XMLResourceBundleFactory
extends org.apache.cocoon.i18n.XMLResourceBundleFactory
implements Observer,
Initializable {
    public static final String BUNDLE_CACHE = XMLResourceBundleFactory.class.getName() + "$bundle";
    private ObservationManager _observationManager;
    private AbstractCacheManager _cacheManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        if (smanager.hasService(ObservationManager.ROLE)) {
            this._observationManager = (ObservationManager)((Object)smanager.lookup(ObservationManager.ROLE));
        }
        this._cacheManager = (AbstractCacheManager)this.manager.lookup(AbstractCacheManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.interval = DevMode.getDeveloperMode() == DevMode.DEVMODE.PRODUCTION ? -1L : 0L;
    }

    public void initialize() throws Exception {
        if (this._observationManager != null) {
            this._observationManager.registerObserver(this);
        }
        this._createCache();
    }

    protected org.apache.cocoon.i18n.XMLResourceBundle create(String sourceURI, Locale locale, org.apache.cocoon.i18n.XMLResourceBundle parent) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating bundle <" + sourceURI + ">");
        }
        XMLResourceBundle bundle = new XMLResourceBundle(sourceURI, locale, (Bundle)parent);
        bundle.enableLogging(this.getLogger());
        bundle.reload(this.manager, this.resolver, this.interval);
        return bundle;
    }

    public void invalidateCatalogue(String location, String name, String localeName) throws ComponentException {
        String cacheKey = "XRB" + this.getCacheKey(new String[]{location}, 0, name, LocaleUtils.toLocale((String)localeName));
        this.cache.remove((Object)cacheKey);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean supports(Event event) {
        return event.getId().equals("cache.reset") && I18nUtils.I18N_CACHE.equals(event.getArguments().get("cache.id"));
    }

    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Enumeration keys = this.cache.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("XRB")) continue;
            this.cache.remove((Object)key);
        }
    }

    public Bundle select(String[] directories, String name, Locale locale) throws ComponentException {
        String cacheKey;
        if (DevMode.getDeveloperMode() == DevMode.DEVMODE.PRODUCTION) {
            return super.select(directories, name, locale);
        }
        Cache<String, Bundle> requestBundleCache = this._getBundleCache();
        if (requestBundleCache.hasKey(cacheKey = this.getCacheKey(directories, 0, name, locale))) {
            return requestBundleCache.get(cacheKey);
        }
        Bundle select = super.select(directories, name, locale);
        requestBundleCache.put(cacheKey, select);
        return select;
    }

    protected Cache<String, Bundle> _getBundleCache() {
        return this._cacheManager.get(BUNDLE_CACHE);
    }

    protected void _createCache() {
        this._cacheManager.createRequestCache(BUNDLE_CACHE, new I18nizableText("plugin.core", "PLUGINS_CORE_I18N_BUNDLECACHE_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_I18N_BUNDLECACHE_DESCRIPTION"), true);
    }
}

