/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class ZipArchiveNGSerializer
extends AbstractSerializer
implements Disposable,
Serviceable {
    public static final String ZIP_NAMESPACE = "http://apache.org/cocoon/zip-archive/1.0";
    private static final int START_STATE = 0;
    private static final int IN_ZIP_STATE = 1;
    private static final int IN_CONTENT_STATE = 2;
    protected ServiceManager _manager;
    protected ServiceSelector _selector;
    protected ZipArchiveOutputStream _zipOutput;
    protected int _state = 0;
    protected SourceResolver _resolver;
    protected byte[] _buffer;
    protected Serializer _serializer;
    protected int _contentDepth;
    private NamespaceSupport _nsSupport = new NamespaceSupport();
    private SAXException _exception;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._resolver = (SourceResolver)this._manager.lookup(SourceResolver.ROLE);
    }

    public String getMimeType() {
        return "application/zip";
    }

    public void startDocument() throws SAXException {
        this._state = 0;
        this._zipOutput = new ZipArchiveOutputStream(this.output);
        this._zipOutput.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        this._zipOutput.setEncoding("UTF-8");
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._state == 2 && this._contentDepth > 0) {
            super.startPrefixMapping(prefix, uri);
        } else if (!uri.equals(ZIP_NAMESPACE)) {
            this._nsSupport.declarePrefix(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this._state == 2 && this._contentDepth > 0) {
            super.endPrefixMapping(prefix);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this._exception != null) {
            throw this._exception;
        }
        switch (this._state) {
            case 0: {
                if (namespaceURI.equals(ZIP_NAMESPACE) && localName.equals("archive")) {
                    this._nsSupport.pushContext();
                    this._state = 1;
                    break;
                }
                this._exception = new SAXException("Expecting 'archive' root element (got '" + localName + "')");
                throw this._exception;
            }
            case 1: {
                if (namespaceURI.equals(ZIP_NAMESPACE) && localName.equals("entry")) {
                    this._nsSupport.pushContext();
                    this.addEntry(atts);
                    break;
                }
                this._exception = new SAXException("Expecting 'entry' element (got '" + localName + "')");
                throw this._exception;
            }
            case 2: {
                if (this._contentDepth == 0) {
                    Enumeration<String> prefixes = this._nsSupport.getPrefixes();
                    while (prefixes.hasMoreElements()) {
                        String prefix = prefixes.nextElement();
                        super.startPrefixMapping(prefix, this._nsSupport.getURI(prefix));
                    }
                }
                ++this._contentDepth;
                super.startElement(namespaceURI, localName, qName, atts);
                break;
            }
        }
    }

    public void characters(char[] buffer, int offset, int length) throws SAXException {
        if (this._state == 2 && this._contentDepth > 0) {
            super.characters(buffer, offset, length);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addEntry(Attributes atts) throws SAXException {
        Source source;
        block20: {
            String name = atts.getValue("name");
            if (name == null) {
                this._exception = new SAXException("No name given to the Zip entry");
                throw this._exception;
            }
            String src = atts.getValue("src");
            String serializerType = atts.getValue("serializer");
            if (src == null && serializerType == null) {
                this._exception = new SAXException("No source nor serializer given for the Zip entry '" + name + "'");
                throw this._exception;
            }
            if (src != null && serializerType != null) {
                this._exception = new SAXException("Cannot specify both 'src' and 'serializer' on a Zip entry '" + name + "'");
                throw this._exception;
            }
            source = null;
            try {
                if (src != null) {
                    source = this._resolver.resolveURI(src);
                    try (InputStream sourceInput = source.getInputStream();){
                        int len;
                        ZipArchiveEntry entry = new ZipArchiveEntry(name);
                        long lastModified = source.getLastModified();
                        if (lastModified != 0L) {
                            entry.setTime(lastModified);
                        }
                        this._zipOutput.putArchiveEntry(entry);
                        if (this._buffer == null) {
                            this._buffer = new byte[8192];
                        }
                        while ((len = sourceInput.read(this._buffer)) > 0) {
                            this._zipOutput.write(this._buffer, 0, len);
                        }
                        this._zipOutput.closeArchiveEntry();
                        break block20;
                    }
                }
                ZipArchiveEntry entry = new ZipArchiveEntry(name);
                this._zipOutput.putArchiveEntry(entry);
                if (this._selector == null) {
                    this._selector = (ServiceSelector)this._manager.lookup(Serializer.ROLE + "Selector");
                }
                this._serializer = (Serializer)this._selector.select((Object)serializerType);
                this._serializer.setOutputStream((OutputStream)new FilterOutputStream(this, (OutputStream)this._zipOutput){

                    @Override
                    public void close() {
                    }
                });
                this.setConsumer((XMLConsumer)this._serializer);
                this._serializer.startDocument();
                this._state = 2;
                this._contentDepth = 0;
            }
            catch (RuntimeException re) {
                try {
                    throw re;
                    catch (SAXException se) {
                        this._exception = se;
                        throw this._exception;
                    }
                    catch (Exception e) {
                        this._exception = new SAXException(e);
                        throw this._exception;
                    }
                }
                catch (Throwable throwable) {
                    this._resolver.release(source);
                    throw throwable;
                }
            }
        }
        this._resolver.release(source);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this._exception != null) {
            throw this._exception;
        }
        if (this._state == 2) {
            super.endElement(namespaceURI, localName, qName);
            --this._contentDepth;
            if (this._contentDepth == 0) {
                Enumeration<String> prefixes = this._nsSupport.getPrefixes();
                while (prefixes.hasMoreElements()) {
                    String prefix = prefixes.nextElement();
                    super.endPrefixMapping(prefix);
                }
                super.endDocument();
                try {
                    this._zipOutput.closeArchiveEntry();
                }
                catch (IOException ioe) {
                    this._exception = new SAXException(ioe);
                    throw this._exception;
                }
                super.setConsumer(null);
                this._selector.release((Object)this._serializer);
                this._serializer = null;
                this._state = 1;
            }
        } else {
            this._nsSupport.popContext();
        }
    }

    public void endDocument() throws SAXException {
        try {
            this._zipOutput.finish();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void recycle() {
        this._exception = null;
        if (this._serializer != null) {
            this._selector.release((Object)this._serializer);
        }
        if (this._selector != null) {
            this._manager.release((Object)this._selector);
        }
        this._nsSupport.reset();
        super.recycle();
    }

    public void dispose() {
        if (this._manager != null) {
            this._manager.release((Object)this._resolver);
            this._resolver = null;
            this._manager = null;
        }
    }
}

