/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.cocoon.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.cocoon.util.NetUtils;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceSource
extends AbstractSource {
    private static final Logger __LOGGER = LoggerFactory.getLogger(ResourceSource.class);
    private URL _location;
    private String _mimeType;
    private String _path;

    public ResourceSource(String systemId) throws MalformedURLException, SourceNotFoundException {
        int pos = SourceUtil.indexOfSchemeColon((String)systemId);
        if (pos == -1 || !systemId.startsWith("://", pos)) {
            throw new MalformedURLException("Invalid format for ResourceSource : " + systemId);
        }
        String scheme = systemId.substring(0, pos);
        this._path = NetUtils.normalize((String)systemId.substring(pos + "://".length())).replace('\\', '/');
        if (this._path.startsWith("/")) {
            this._path = this._path.substring(1);
        }
        this.setSystemId(scheme + "://" + this._path);
        this._location = this.getClassLoader().getResource(this._path);
        this.setScheme(scheme);
    }

    public boolean exists() {
        return this._location != null;
    }

    protected void getInfos() {
        block10: {
            URLConnection connection = null;
            try {
                if (this._location == null) {
                    this.setLastModified(0L);
                    this.setContentLength(-1L);
                    this._mimeType = null;
                    return;
                }
                this._mimeType = URLConnection.getFileNameMap().getContentTypeFor(this._path);
                connection = this._location.openConnection();
                if (connection instanceof JarURLConnection) {
                    URL jarFileURL = ((JarURLConnection)connection).getJarFileURL();
                    if ("file".equals(jarFileURL.getProtocol())) {
                        File file = new File(jarFileURL.toURI());
                        try (JarFile jarFile = new JarFile(file);){
                            ZipEntry entry = jarFile.getEntry(this._path);
                            this.setLastModified(entry.getTime());
                            this.setContentLength(entry.getSize());
                            break block10;
                        }
                    }
                    URLConnection jarconnection = jarFileURL.openConnection();
                    this.setLastModified(jarconnection.getLastModified());
                    jarconnection.getInputStream().close();
                    this.setContentLength(connection.getContentLength());
                    break block10;
                }
                this.setLastModified(connection.getLastModified());
                this.setContentLength(connection.getContentLength());
            }
            catch (Exception e) {
                __LOGGER.error("An error occurred while accessing info for resource " + this._path, (Throwable)e);
                this.setLastModified(0L);
                this.setContentLength(-1L);
                this._mimeType = null;
            }
        }
    }

    public String getMimeType() {
        this.checkInfos();
        return this._mimeType;
    }

    public InputStream getInputStream() throws IOException {
        if (this._location == null) {
            throw new SourceNotFoundException("Resource not found for URI : " + this.getURI());
        }
        InputStream in = this._location.openStream();
        if (in == null) {
            throw new SourceNotFoundException("Source '" + String.valueOf(this._location) + "' was not found");
        }
        return in;
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    private ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        return loader;
    }

    public URL getLocation() {
        return this._location;
    }
}

