/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.core.datasource.DataSourceConsumerExtensionPoint;
import org.ametys.core.datasource.UnknownDataSourceException;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.StringUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractDataSourceManager
extends AbstractLogEnabled
implements Component,
Initializable,
Serviceable,
Disposable {
    public static final String DEFAULT_DATASOURCE_SUFFIX = "default-datasource";
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected Map<String, DataSourceDefinition> _dataSourcesDef;
    private long _lastUpdate;
    private DataSourceConsumerExtensionPoint _dataSourceConsumerEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._dataSourceConsumerEP = (DataSourceConsumerExtensionPoint)serviceManager.lookup(DataSourceConsumerExtensionPoint.ROLE);
        try {
            this._observationManager = (ObservationManager)((Object)serviceManager.lookup(ObservationManager.ROLE));
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public void initialize() throws Exception {
        this._dataSourcesDef = new HashMap<String, DataSourceDefinition>();
        this.readConfiguration();
        for (DataSourceDefinition def : this._dataSourcesDef.values()) {
            try {
                this.checkParameters(def.getParameters());
            }
            catch (ItemCheckerTestFailureException e) {
                DataSourceConsumer.TypeOfUse typeOfUse = DataSourceConsumer.TypeOfUse.merge(this._dataSourceConsumerEP.isInUse(def.getId()), def.isDefault() ? this._dataSourceConsumerEP.isInUse(this.getDefaultDataSourceId()) : DataSourceConsumer.TypeOfUse.NOT_USED);
                if (!PluginsManager.getInstance().isSafeMode() && typeOfUse == DataSourceConsumer.TypeOfUse.BLOCKING) {
                    throw e;
                }
                this.getLogger().warn("The data source '{}' is currently invalid", (Object)def.getId(), (Object)e);
            }
            this.createDataSource(def);
        }
        if (this.getDefaultDataSourceDefinition() == null) {
            this.internalSetDefaultDataSource();
        }
        this.checkDataSources();
    }

    public abstract File getFileConfiguration();

    protected abstract String getDataSourcePrefixId();

    public abstract void checkParameters(Map<String, Object> var1) throws ItemCheckerTestFailureException;

    protected abstract void createDataSource(DataSourceDefinition var1);

    protected abstract void editDataSource(DataSourceDefinition var1);

    protected abstract void deleteDataSource(DataSourceDefinition var1);

    protected abstract void internalSetDefaultDataSource();

    public Map<String, DataSourceDefinition> getDataSourceDefinitions(boolean includePrivate, boolean includeInternal, boolean includeDefault) {
        DataSourceDefinition defaultDataSourceDefinition;
        this.readConfiguration();
        HashMap<String, DataSourceDefinition> dataSourceDefinitions = new HashMap<String, DataSourceDefinition>();
        if (includeDefault && (defaultDataSourceDefinition = this.getDefaultDataSourceDefinition()) != null) {
            dataSourceDefinitions.put(this.getDefaultDataSourceId(), defaultDataSourceDefinition);
        }
        if (includePrivate) {
            dataSourceDefinitions.putAll(this._dataSourcesDef);
            return dataSourceDefinitions;
        }
        HashMap<String, DataSourceDefinition> publicDatasources = new HashMap<String, DataSourceDefinition>();
        for (DataSourceDefinition definition : this._dataSourcesDef.values()) {
            if (definition.isPrivate()) continue;
            publicDatasources.put(definition.getId(), definition);
        }
        dataSourceDefinitions.putAll(publicDatasources);
        return dataSourceDefinitions;
    }

    public DataSourceDefinition getDataSourceDefinition(String id) {
        this.readConfiguration();
        if (this.getDefaultDataSourceId().equals(id)) {
            return this.getDefaultDataSourceDefinition();
        }
        return this._dataSourcesDef.get(id);
    }

    public DataSourceDefinition add(I18nizableText name, I18nizableText description, Map<String, Object> parameters, boolean isPrivate) {
        this.readConfiguration();
        String id = this.getDataSourcePrefixId() + StringUtils.generateKey();
        DataSourceDefinition ds = new DataSourceDefinition(id, name, description, parameters, isPrivate, false);
        this._dataSourcesDef.put(id, ds);
        this.saveConfiguration();
        this.createDataSource(ds);
        if (this.getDataSourceDefinitions(true, true, false).size() == 1) {
            this.internalSetDefaultDataSource();
        }
        if (this._observationManager != null) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("datasource-ids", Collections.singletonList(ds.getId()));
            this._observationManager.notify(new Event("datasource.added", this._currentUserProvider.getUser(), eventParams));
        }
        return ds;
    }

    public DataSourceDefinition edit(String id, I18nizableText name, I18nizableText description, Map<String, Object> parameters, boolean isPrivate) {
        this.readConfiguration();
        if (this._dataSourcesDef.containsKey(id)) {
            boolean isDefault = this._dataSourcesDef.get(id).isDefault();
            DataSourceDefinition ds = new DataSourceDefinition(id, name, description, parameters, isPrivate, isDefault);
            this._dataSourcesDef.put(id, ds);
            this.saveConfiguration();
            this.editDataSource(ds);
            if (this._observationManager != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("datasource-ids", Collections.singletonList(ds.getId()));
                this._observationManager.notify(new Event("datasource.updated", this._currentUserProvider.getUser(), eventParams));
            }
            return ds;
        }
        throw new RuntimeException("The data source with id '" + id + "' was not found. Unable to edit it.");
    }

    public void delete(Collection<String> dataSourceIds, boolean forceDeletion) {
        this.readConfiguration();
        for (String id : dataSourceIds) {
            DataSourceDefinition dataSourceDef = this._dataSourcesDef.get(id);
            if (!forceDeletion) {
                DataSourceConsumer.TypeOfUse[] typeOfUseArray = new DataSourceConsumer.TypeOfUse[2];
                typeOfUseArray[0] = this._dataSourceConsumerEP.isInUse(id);
                DataSourceConsumer.TypeOfUse typeOfUse = typeOfUseArray[1] = dataSourceDef.isDefault() ? this._dataSourceConsumerEP.isInUse(this.getDefaultDataSourceId()) : DataSourceConsumer.TypeOfUse.NOT_USED;
                if (DataSourceConsumer.TypeOfUse.merge(typeOfUseArray) != DataSourceConsumer.TypeOfUse.NOT_USED) {
                    throw new IllegalStateException("The data source '" + id + "' is currently in use. The deletion process has been aborted.");
                }
            }
            if (id.equals("SQL-ametys-internal")) {
                throw new IllegalStateException("The data source '" + id + "' is an internal data source. The deletion process has been aborted.");
            }
            this.deleteDataSource(dataSourceDef);
            this._dataSourcesDef.remove(id);
        }
        this.saveConfiguration();
        if (this.getDataSourceDefinitions(true, true, false).size() == 1) {
            this.internalSetDefaultDataSource();
        }
        if (this._observationManager != null) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("datasource-ids", dataSourceIds);
            this._observationManager.notify(new Event("datasource.deleted", this._currentUserProvider.getUser(), eventParams));
        }
    }

    public DataSourceDefinition setDefaultDataSource(String id) {
        this.readConfiguration();
        if (!id.startsWith(this.getDataSourcePrefixId())) {
            throw new RuntimeException("The data source with id '" + id + "' is not of the appropriate type to set is as default.");
        }
        DataSourceDefinition oldDefaultDataSource = this.getDefaultDataSourceDefinition();
        if (oldDefaultDataSource != null) {
            oldDefaultDataSource.setDefault(false);
            this._dataSourcesDef.put(oldDefaultDataSource.getId(), oldDefaultDataSource);
            this.saveConfiguration();
            this.editDataSource(oldDefaultDataSource);
        }
        if (this._dataSourcesDef.containsKey(id)) {
            DataSourceDefinition newDefaultDataSource = this.getDataSourceDefinition(id);
            newDefaultDataSource.setDefault(true);
            this._dataSourcesDef.put(id, newDefaultDataSource);
            this.saveConfiguration();
            this.editDataSource(newDefaultDataSource);
            return newDefaultDataSource;
        }
        throw new RuntimeException("The data source with id '" + id + "' was not found. Unable to set it as the default data source.");
    }

    public DataSourceDefinition getDefaultDataSourceDefinition() {
        ArrayList<DataSourceDefinition> defaultDataSourceDefinitions = new ArrayList<DataSourceDefinition>();
        for (DataSourceDefinition definition : this._dataSourcesDef.values()) {
            if (!definition.getId().startsWith(this.getDataSourcePrefixId()) || !definition.isDefault()) continue;
            defaultDataSourceDefinitions.add(definition);
        }
        if (defaultDataSourceDefinitions.isEmpty()) {
            return null;
        }
        if (defaultDataSourceDefinitions.size() > 1) {
            throw new IllegalStateException("Found more than one default data source definition.");
        }
        return (DataSourceDefinition)defaultDataSourceDefinitions.get(0);
    }

    public String getDefaultDataSourceId() {
        return this.getDataSourcePrefixId() + DEFAULT_DATASOURCE_SUFFIX;
    }

    protected final void readConfiguration() {
        File file = this.getFileConfiguration();
        if (file.exists() && file.lastModified() > this._lastUpdate) {
            this._lastUpdate = new Date().getTime();
            this._dataSourcesDef = this.doReadConfiguration(file);
        }
    }

    protected abstract Map<String, DataSourceDefinition> doReadConfiguration(File var1);

    protected void saveConfiguration() {
        File file = this.getFileConfiguration();
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            try (FileOutputStream os = new FileOutputStream(file);){
                StreamResult sResult = new StreamResult(os);
                th.setResult(sResult);
                Properties format = new Properties();
                format.put("method", "xml");
                format.put("indent", "yes");
                format.put("encoding", "UTF-8");
                format.put("{http://xml.apache.org/xalan}indent-amount", "4");
                th.getTransformer().setOutputProperties(format);
                th.startDocument();
                XMLUtils.startElement((ContentHandler)th, (String)"datasources");
                for (DataSourceDefinition datasource : this._dataSourcesDef.values()) {
                    this.saxDataSource(th, datasource);
                }
                XMLUtils.endElement((ContentHandler)th, (String)"datasources");
                th.endDocument();
            }
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to save the configuration of data sources", e);
        }
    }

    protected void saxDataSource(ContentHandler handler, DataSourceDefinition dataSource) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", dataSource.getId());
        attrs.addCDATAAttribute("private", String.valueOf(dataSource.isPrivate()));
        attrs.addCDATAAttribute("default", String.valueOf(dataSource.isDefault()));
        XMLUtils.startElement((ContentHandler)handler, (String)"datasource", (Attributes)attrs);
        dataSource.getName().toSAX(handler, "name");
        dataSource.getDescription().toSAX(handler, "description");
        XMLUtils.startElement((ContentHandler)handler, (String)"parameters");
        Map<String, Object> parameters = dataSource.getParameters();
        Iterator<String> iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String paramName;
            Object value = parameters.get(paramName = iterator.next());
            XMLUtils.createElement((ContentHandler)handler, (String)paramName, (String)(value != null ? value.toString() : ""));
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"parameters");
        XMLUtils.endElement((ContentHandler)handler, (String)"datasource");
    }

    protected void checkDataSources() {
        Set<String> usedDataSourceIds = this._dataSourceConsumerEP.getUsedDataSourceIds().keySet();
        for (String dataSourceId : usedDataSourceIds) {
            if (dataSourceId == null || !dataSourceId.startsWith(this.getDataSourcePrefixId()) || this.getDataSourceDefinition(dataSourceId) != null || PluginsManager.getInstance().isSafeMode()) continue;
            throw new UnknownDataSourceException("The data source '" + dataSourceId + "' was not found in the available data sources.");
        }
    }

    public void dispose() {
        for (DataSourceDefinition ds : this._dataSourcesDef.values()) {
            this.deleteDataSource(ds);
        }
        this._dataSourcesDef.clear();
        this._lastUpdate = 0L;
    }

    public static class DataSourceDefinition
    implements Cloneable {
        private String _id;
        private I18nizableText _name;
        private I18nizableText _description;
        private Map<String, Object> _parameters;
        private boolean _isPrivate;
        private boolean _isDefault;

        public DataSourceDefinition(String id, I18nizableText name, I18nizableText description, Map<String, Object> parameters, boolean isPrivate, boolean isDefault) {
            this._id = id;
            this._name = name;
            this._description = description;
            this._parameters = parameters;
            this._isPrivate = isPrivate;
            this._isDefault = isDefault;
        }

        public String getId() {
            return this._id;
        }

        public I18nizableText getName() {
            return this._name;
        }

        public I18nizableText getDescription() {
            return this._description;
        }

        public boolean isPrivate() {
            return this._isPrivate;
        }

        public boolean isDefault() {
            return this._isDefault;
        }

        public void setDefault(boolean isDefault) {
            this._isDefault = isDefault;
        }

        public Map<String, Object> getParameters() {
            return this._parameters;
        }

        public DataSourceDefinition duplicate() {
            return new DataSourceDefinition(this._id, this._name, this._description, new HashMap<String, Object>(this._parameters), this._isPrivate, this._isDefault);
        }
    }
}

